/*
 * 32x24 hit data
 */

#define F_1	0x80
#define F_2	0x81
#define F_3	0x82
#define F_4	0x83
#define F_5	0x84
#define F_6	0x85
#define F_7	0x86
#define F_8	0x87
#define F_9	0x88
#define F10	0x89
#define F11	0x8a
#define F12	0x8b

#define EXT	0x8c // Exit

#define HOM	0xf // Home
#define PGU	0x3 // Page Up
#define PGD	0x5 // Page Down
#define END	0x10 // End

#define TAB	0x9

#define ESC	0x1b // Escape
#define BSP	0x8 // Backspace
#define CAP	0x2 // Caps
#define RET	'\n' // Enter
#define SHF	0x4 // Shift
#define	CTL	0x1d // Ctrl
#define SPC	0x20 // Space
#define ALT	0x38 // Alt
#define DSB	0x4a // DS
#define SCN	0x46 // Screen

#define CRU	0xb // Cursor up
#define CRD	0xc // Cursor down
#define CRL	0xd // Cursor Left
#define CRR	0xe // Cursor Right

#define INS	0x52 // Insert
#define DEL	0x53 // Delete

const unsigned char keyboard_Hit[512] = {
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,ESC,ESC,0x0,F_1,F_1,F_2,F_2,F_3,F_3,F_4,F_4,F_5,F_5,F_6,F_6,F_7,F_7,F_8,F_8,F_9,F_9,F10,F10,F11,F11,F12,F12,0x0,EXT,EXT,0x0,
0x0,ESC,ESC,0x0,F_1,F_1,F_2,F_2,F_3,F_3,F_4,F_4,F_5,F_5,F_6,F_6,F_7,F_7,F_8,F_8,F_9,F_9,F10,F10,F11,F11,F12,F12,0x0,EXT,EXT,0x0,
0x0,'1','1','2','2','3','3','4','4','5','5','6','6','7','7','8','8','9','9','0','0','-','-','=','=',BSP,BSP,BSP,BSP,HOM,HOM,0x0,
0x0,'1','1','2','2','3','3','4','4','5','5','6','6','7','7','8','8','9','9','0','0','-','-','=','=',BSP,BSP,BSP,BSP,HOM,HOM,0x0,
0x0,TAB,'q','q','w','w','e','e','r','r','t','t','y','y','u','u','i','i','o','o','p','p','[','[',']',']','\\','\\',0x0,PGU,PGU,0x0,
0x0,TAB,'q','q','w','w','e','e','r','r','t','t','y','y','u','u','i','i','o','o','p','p','[','[',']',']','\\','\\',0x0,PGU,PGU,0x0,
0x0,CAP,CAP,'a','a','s','s','d','d','f','f','g','g','h','h','j','j','k','k','l','l',';',';','\'','\'',RET,RET,RET,RET,PGD,PGD,0x0,
0x0,CAP,CAP,'a','a','s','s','d','d','f','f','g','g','h','h','j','j','k','k','l','l',';',';','\'','\'',RET,RET,RET,RET,PGD,PGD,0x0,
0x0,SHF,SHF,SHF,'z','z','x','x','c','c','v','v','b','b','n','n','m','m',',',',','.','.','/','/',SHF,SHF,SHF,CRU,CRU,END,END,0x0,
0x0,SHF,SHF,SHF,'z','z','x','x','c','c','v','v','b','b','n','n','m','m',',',',','.','.','/','/',SHF,SHF,SHF,CRU,CRU,END,END,0x0,
0x0,CTL,CTL,DSB,DSB,ALT,ALT,'`','`',SPC,SPC,SPC,SPC,SPC,SPC,SPC,SPC,SPC,SPC,INS,INS,DEL,DEL,SCN,SCN,CRL,CRL,CRD,CRD,CRR,CRR,0x0,
0x0,CTL,CTL,DSB,DSB,ALT,ALT,'`','`',SPC,SPC,SPC,SPC,SPC,SPC,SPC,SPC,SPC,SPC,INS,INS,DEL,DEL,SCN,SCN,CRL,CRL,CRD,CRD,CRR,CRR,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
};

const unsigned char keyboard_Hit_Shift[512] = {
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,ESC,ESC,0x0,F_1,F_1,F_2,F_2,F_3,F_3,F_4,F_4,F_5,F_5,F_6,F_6,F_7,F_7,F_8,F_8,F_9,F_9,F10,F10,F11,F11,F12,F12,0x0,EXT,EXT,0x0,
0x0,ESC,ESC,0x0,F_1,F_1,F_2,F_2,F_3,F_3,F_4,F_4,F_5,F_5,F_6,F_6,F_7,F_7,F_8,F_8,F_9,F_9,F10,F10,F11,F11,F12,F12,0x0,EXT,EXT,0x0,
0x0,'!','!','@','@','#','#','$','$','%','%','^','^','&','&','*','*','(','(',')',')','_','_','+','+',BSP,BSP,BSP,BSP,HOM,HOM,0x0,
0x0,'!','!','@','@','#','#','$','$','%','%','^','^','&','&','*','*','(','(',')',')','_','_','+','+',BSP,BSP,BSP,BSP,HOM,HOM,0x0,
0x0,TAB,'Q','Q','W','W','E','E','R','R','T','T','Y','Y','U','U','I','I','O','O','P','P','{','{','}','}','|','|',0x0,PGU,PGU,0x0,
0x0,TAB,'Q','Q','W','W','E','E','R','R','T','T','Y','Y','U','U','I','I','O','O','P','P','{','{','}','}','|','|',0x0,PGU,PGU,0x0,
0x0,CAP,CAP,'A','A','S','S','D','D','F','F','G','G','H','H','J','J','K','K','L','L',':',':','"','"',RET,RET,RET,RET,PGD,PGD,0x0,
0x0,CAP,CAP,'A','A','S','S','D','D','F','F','G','G','H','H','J','J','K','K','L','L',':',':','"','"',RET,RET,RET,RET,PGD,PGD,0x0,
0x0,SHF,SHF,SHF,'Z','Z','X','X','C','C','V','V','B','B','N','N','M','M','<','<','>','>','?','?',SHF,SHF,SHF,CRU,CRU,END,END,0x0,
0x0,SHF,SHF,SHF,'Z','Z','X','X','C','C','V','V','B','B','N','N','M','M','<','<','>','>','?','?',SHF,SHF,SHF,CRU,CRU,END,END,0x0,
0x0,CTL,CTL,DSB,DSB,ALT,ALT,'~','~',SPC,SPC,SPC,SPC,SPC,SPC,SPC,SPC,SPC,SPC,INS,INS,DEL,DEL,SCN,SCN,CRL,CRL,CRD,CRD,CRR,CRR,0x0,
0x0,CTL,CTL,DSB,DSB,ALT,ALT,'~','~',SPC,SPC,SPC,SPC,SPC,SPC,SPC,SPC,SPC,SPC,INS,INS,DEL,DEL,SCN,SCN,CRL,CRL,CRD,CRD,CRR,CRR,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
};

/*
 * 32x32 map data
 */
const unsigned short keyboard_Map[1024] = {
0x0000, 0x0001, 0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001,
0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0001, 0x0003,
0x0004, 0x0005, 0x0006, 0x0007, 0x0008, 0x0009, 0x000a, 0x000b,
0x000a, 0x000c, 0x000a, 0x000d, 0x000a, 0x000e, 0x000f, 0x0010,
0x0011, 0x0012, 0x000f, 0x0013, 0x000f, 0x0014, 0x0015, 0x0016,
0x0017, 0x0018, 0x0017, 0x0019, 0x0007, 0x001a, 0x001b, 0x001c,
0x001d, 0x001e, 0x001f, 0x0020, 0x0021, 0x0022, 0x0023, 0x0024,
0x0021, 0x0025, 0x0021, 0x0026, 0x0021, 0x0025, 0x0027, 0x0028,
0x0027, 0x0029, 0x0027, 0x0028, 0x0027, 0x002a, 0x002b, 0x002c,
0x002d, 0x002e, 0x002f, 0x0030, 0x0020, 0x0031, 0x0032, 0x0033,
0x0034, 0x0035, 0x0036, 0x0037, 0x0038, 0x0039, 0x0038, 0x003a,
0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 0x0040, 0x0041, 0x0042,
0x0038, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048,
0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 0x0050,
0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058,
0x0059, 0x0056, 0x0057, 0x005a, 0x0057, 0x005b, 0x0053, 0x005a,
0x0057, 0x005c, 0x0057, 0x005d, 0x0057, 0x005e, 0x005f, 0x0060,
0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068,
0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 0x0070,
0x0071, 0x0072, 0x0073, 0x0072, 0x0074, 0x0075, 0x0076, 0x006e,
0x0077, 0x0078, 0x006b, 0x0079, 0x007a, 0x0079, 0x007b, 0x007c,
0x007d, 0x007e, 0x007f, 0x0080, 0x0007, 0x0081, 0x0082, 0x0083,
0x0084, 0x0085, 0x0086, 0x0087, 0x0088, 0x0089, 0x008a, 0x008b,
0x008c, 0x0053, 0x008d, 0x008e, 0x008f, 0x0090, 0x008a, 0x0091,
0x0092, 0x0093, 0x008a, 0x0094, 0x0095, 0x0096, 0x0097, 0x0098,
0x0099, 0x009a, 0x009b, 0x009c, 0x0020, 0x009d, 0x009e, 0x009f,
0x00a0, 0x00a1, 0x00a2, 0x0048, 0x00a3, 0x00a4, 0x00a5, 0x00a4,
0x00a6, 0x00a7, 0x00a8, 0x00a4, 0x00a9, 0x00aa, 0x00a3, 0x00ab,
0x00ac, 0x00ad, 0x00a5, 0x00ae, 0x0078, 0x00af, 0x0078, 0x00b0,
0x0078, 0x00b1, 0x00b2, 0x00b3, 0x004d, 0x0081, 0x00b4, 0x00b5,
0x00b6, 0x00b7, 0x00b8, 0x00b9, 0x00ba, 0x00bb, 0x00bc, 0x00bd,
0x00be, 0x00bf, 0x00c0, 0x00c1, 0x00c2, 0x00c3, 0x00c4, 0x00c5,
0x009a, 0x00c6, 0x00c7, 0x00c8, 0x00c9, 0x00ca, 0x0053, 0x00cb,
0x0053, 0x00cc, 0x00cd, 0x00ce, 0x0065, 0x009d, 0x00cf, 0x00d0,
0x00d1, 0x00d2, 0x00d3, 0x00d4, 0x0048, 0x00d5, 0x00d6, 0x00d7,
0x00a4, 0x00d8, 0x00d9, 0x00da, 0x00aa, 0x00a3, 0x00db, 0x00a3,
0x00dc, 0x00dd, 0x00ab, 0x0078, 0x00ab, 0x0078, 0x00de, 0x00df,
0x00e0, 0x00e1, 0x00e2, 0x00e3, 0x00e4, 0x00e5, 0x00e6, 0x00e7,
0x00e8, 0x00e9, 0x00ea, 0x00eb, 0x00ec, 0x00ed, 0x00ee, 0x00ef,
0x00bd, 0x00ed, 0x00f0, 0x00f1, 0x00f2, 0x00f3, 0x00f4, 0x00f5,
0x00f6, 0x00f7, 0x00f8, 0x0053, 0x00f9, 0x0053, 0x00fa, 0x00c9,
0x00fb, 0x00fc, 0x00fd, 0x00fe, 0x00ff, 0x0100, 0x0101, 0x0102,
0x001d, 0x0103, 0x0104, 0x0105, 0x0106, 0x0107, 0x0108, 0x0109,
0x0078, 0x010a, 0x010b, 0x010c, 0x010d, 0x010e, 0x010f, 0x0110,
0x0111, 0x0112, 0x0113, 0x0114, 0x0115, 0x0116, 0x0117, 0x0118,
0x0119, 0x011a, 0x011b, 0x011c, 0x011d, 0x011e, 0x011f, 0x0033,
0x0120, 0x0121, 0x0122, 0x0123, 0x0124, 0x0125, 0x0126, 0x0127,
0x0128, 0x0129, 0x012a, 0x012b, 0x012c, 0x012d, 0x012e, 0x012f,
0x0130, 0x0131, 0x0132, 0x0133, 0x0134, 0x0135, 0x0136, 0x0137,
0x0138, 0x0139, 0x013a, 0x013b, 0x013c, 0x013d, 0x013e, 0x013f,
0x0140, 0x0141, 0x0141, 0x0141, 0x0141, 0x0141, 0x0141, 0x0141,
0x0141, 0x0141, 0x0141, 0x0141, 0x0141, 0x0141, 0x0141, 0x0141,
0x0141, 0x0141, 0x0141, 0x0141, 0x0141, 0x0141, 0x0141, 0x0141,
0x0141, 0x0141, 0x0141, 0x0141, 0x0141, 0x0141, 0x0141, 0x0142,
0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143,
0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143,
0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143,
0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143,
0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143,
0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143,
0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143,
0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143,
0x0000, 0x0001, 0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001,
0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0001, 0x0003,
0x0004, 0x0005, 0x0006, 0x0007, 0x0008, 0x0009, 0x000a, 0x000b,
0x000a, 0x000c, 0x000a, 0x000d, 0x000a, 0x000e, 0x000f, 0x0010,
0x0011, 0x0012, 0x000f, 0x0013, 0x000f, 0x0014, 0x0015, 0x0016,
0x0017, 0x0018, 0x0017, 0x0019, 0x0007, 0x001a, 0x001b, 0x001c,
0x001d, 0x001e, 0x001f, 0x0020, 0x0021, 0x0022, 0x0023, 0x0024,
0x0021, 0x0025, 0x0021, 0x0026, 0x0021, 0x0025, 0x0027, 0x0028,
0x0027, 0x0029, 0x0027, 0x0028, 0x0027, 0x002a, 0x002b, 0x002c,
0x002d, 0x002e, 0x002f, 0x0030, 0x0020, 0x0031, 0x0032, 0x0033,
0x0034, 0x0144, 0x0036, 0x0145, 0x0146, 0x0147, 0x0148, 0x0149,
0x014a, 0x014b, 0x014c, 0x014d, 0x014e, 0x014f, 0x0150, 0x0151,
0x0152, 0x0153, 0x007c, 0x0154, 0x0155, 0x00ab, 0x0078, 0x0156,
0x0157, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 0x0050,
0x0051, 0x0158, 0x00c9, 0x0159, 0x015a, 0x015b, 0x015c, 0x015d,
0x015e, 0x015f, 0x0160, 0x00cb, 0x0053, 0x0161, 0x0162, 0x0163,
0x0164, 0x0165, 0x0166, 0x0167, 0x0090, 0x0168, 0x00ed, 0x0169,
0x016a, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068,
0x0069, 0x006a, 0x016b, 0x016c, 0x016d, 0x003b, 0x003c, 0x003f,
0x003c, 0x0038, 0x016e, 0x016f, 0x0170, 0x014c, 0x003a, 0x003b,
0x0171, 0x0078, 0x016b, 0x016c, 0x003c, 0x0038, 0x0172, 0x007c,
0x007d, 0x0173, 0x0174, 0x0080, 0x0007, 0x0081, 0x0082, 0x0083,
0x0084, 0x0085, 0x0175, 0x0176, 0x0177, 0x0178, 0x0054, 0x0098,
0x0179, 0x017a, 0x005b, 0x0053, 0x005b, 0x0053, 0x005a, 0x0057,
0x005b, 0x0053, 0x005a, 0x0057, 0x017b, 0x00c9, 0x00c8, 0x0098,
0x0099, 0x017c, 0x017d, 0x017e, 0x0020, 0x009d, 0x009e, 0x009f,
0x00a0, 0x00a1, 0x00a2, 0x017f, 0x0180, 0x0042, 0x007c, 0x0181,
0x016c, 0x0182, 0x0183, 0x0044, 0x0183, 0x0184, 0x0185, 0x00ab,
0x0186, 0x0187, 0x0188, 0x00ae, 0x0078, 0x00af, 0x0078, 0x0189,
0x00df, 0x00b1, 0x00b2, 0x00b3, 0x004d, 0x0081, 0x00b4, 0x00b5,
0x00b6, 0x00b7, 0x00b8, 0x018a, 0x0059, 0x018b, 0x018c, 0x018d,
0x0057, 0x00bf, 0x00c9, 0x005a, 0x0057, 0x018e, 0x018f, 0x018b,
0x018c, 0x0190, 0x0191, 0x0097, 0x0055, 0x0192, 0x0093, 0x00cb,
0x0053, 0x00cc, 0x00cd, 0x00ce, 0x0065, 0x009d, 0x00cf, 0x00d0,
0x00d1, 0x00d2, 0x00d3, 0x00d4, 0x0193, 0x0194, 0x0170, 0x014c,
0x016b, 0x016f, 0x0195, 0x0196, 0x003c, 0x0038, 0x0197, 0x003b,
0x0198, 0x0199, 0x019a, 0x0072, 0x019b, 0x019c, 0x019d, 0x019e,
0x00e0, 0x00e1, 0x00e2, 0x00e3, 0x00e4, 0x00e5, 0x00e6, 0x00e7,
0x00e8, 0x00e9, 0x00ea, 0x00eb, 0x019f, 0x0098, 0x01a0, 0x017a,
0x00bd, 0x00ed, 0x00f0, 0x01a1, 0x01a2, 0x01a3, 0x01a4, 0x01a5,
0x01a6, 0x01a7, 0x01a8, 0x01a9, 0x01aa, 0x0093, 0x01ab, 0x0053,
0x00fb, 0x00fc, 0x00fd, 0x00fe, 0x00ff, 0x0100, 0x0101, 0x0102,
0x001d, 0x0103, 0x0104, 0x0105, 0x0106, 0x0107, 0x0108, 0x01ac,
0x01ad, 0x010a, 0x010b, 0x010c, 0x010d, 0x010e, 0x010f, 0x0110,
0x0111, 0x0112, 0x0113, 0x0114, 0x0115, 0x0116, 0x0117, 0x0118,
0x0119, 0x011a, 0x011b, 0x011c, 0x011d, 0x011e, 0x011f, 0x0033,
0x0120, 0x0121, 0x0122, 0x0123, 0x0124, 0x0125, 0x0126, 0x0127,
0x0128, 0x0129, 0x012a, 0x012b, 0x012c, 0x012d, 0x012e, 0x012f,
0x0130, 0x0131, 0x0132, 0x0133, 0x0134, 0x0135, 0x0136, 0x0137,
0x0138, 0x0139, 0x013a, 0x013b, 0x013c, 0x013d, 0x013e, 0x013f,
0x0140, 0x0141, 0x0141, 0x0141, 0x0141, 0x0141, 0x0141, 0x0141,
0x0141, 0x0141, 0x0141, 0x0141, 0x0141, 0x0141, 0x0141, 0x0141,
0x0141, 0x0141, 0x0141, 0x0141, 0x0141, 0x0141, 0x0141, 0x0141,
0x0141, 0x0141, 0x0141, 0x0141, 0x0141, 0x0141, 0x0141, 0x0142,
0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143,
0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143,
0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143,
0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143,
0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143,
0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143,
0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143,
0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143
};

//
// keyboard (13760 uncompressed bytes)
//
const unsigned char keyboard_Tiles[13760] = {
0x00, 0x00, 0x20, 0x22, 0x00, 0x20, 0x22, 0xdd, 0x00, 0x22, 0xdb, 0xdd, 0x20, 0xb2, 0xdd, 0xdd,
0x20, 0xba, 0xbb, 0xab, 0x22, 0xaa, 0xaa, 0x66, 0x62, 0x66, 0x66, 0x66, 0x92, 0x66, 0x66, 0x26,
0x22, 0x22, 0x22, 0x22, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
0xaa, 0xaa, 0xaa, 0xaa, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x22, 0x22, 0x22, 0x22,
0x22, 0x22, 0x22, 0x22, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
0xaa, 0xaa, 0xaa, 0xaa, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x26,
0x22, 0x02, 0x00, 0x00, 0xdd, 0x22, 0x02, 0x00, 0xdd, 0xbd, 0x22, 0x00, 0xdd, 0xdd, 0x2b, 0x02,
0xba, 0xbb, 0xab, 0x02, 0x66, 0xaa, 0xaa, 0x22, 0x66, 0x66, 0x66, 0x26, 0x66, 0x66, 0x66, 0x29,
0x92, 0x69, 0x66, 0x26, 0x92, 0x69, 0x66, 0x26, 0x92, 0x69, 0x66, 0x26, 0x92, 0x99, 0x66, 0x26,
0x92, 0x69, 0x66, 0x26, 0x92, 0x69, 0x66, 0x26, 0x92, 0x99, 0x66, 0x26, 0x92, 0x69, 0x66, 0x26,
0x49, 0xdc, 0xaa, 0xaa, 0x14, 0xc1, 0xdd, 0xdd, 0x11, 0x7d, 0x77, 0x73, 0xcc, 0x73, 0x37, 0x33,
0xcc, 0x37, 0x33, 0x93, 0xdc, 0x22, 0x92, 0x29, 0xcc, 0x92, 0x99, 0x62, 0xdc, 0x22, 0x69, 0x26,
0xaa, 0x6a, 0x49, 0x29, 0xdd, 0xbd, 0x76, 0x24, 0x33, 0x33, 0x96, 0x27, 0x33, 0x33, 0x93, 0x24,
0x99, 0x66, 0x96, 0x24, 0x62, 0x26, 0x92, 0x24, 0xa6, 0xb2, 0x9b, 0x24, 0xb6, 0xd2, 0x9d, 0x24,
0x66, 0x66, 0x66, 0x26, 0x66, 0x66, 0x66, 0x26, 0x66, 0x66, 0x66, 0x26, 0x66, 0x66, 0x66, 0x26,
0x66, 0x66, 0x66, 0x26, 0x66, 0x66, 0x66, 0x26, 0x66, 0x66, 0x66, 0x26, 0x66, 0x66, 0x66, 0x26,
0x49, 0xdc, 0xaa, 0xaa, 0x14, 0xd1, 0xdd, 0xdd, 0x11, 0x3d, 0x77, 0x73, 0xcc, 0x77, 0x77, 0x33,
0xdc, 0x27, 0x22, 0x32, 0xdc, 0x27, 0x33, 0x99, 0xdc, 0x23, 0x99, 0x69, 0xdc, 0x23, 0x22, 0x62,
0xaa, 0x6a, 0x49, 0x29, 0xdd, 0xbd, 0x76, 0x24, 0x33, 0x33, 0x96, 0x27, 0x33, 0x33, 0x99, 0x27,
0x23, 0x62, 0x96, 0x27, 0x69, 0x62, 0x9a, 0x27, 0x66, 0xb2, 0x9b, 0x27, 0xb6, 0xd2, 0x9b, 0x27,
0x49, 0xdc, 0xaa, 0xaa, 0x14, 0xd1, 0xdd, 0xdd, 0x11, 0x3d, 0x77, 0x73, 0xc1, 0x77, 0x77, 0x33,
0xdc, 0x27, 0x22, 0x32, 0xdc, 0x27, 0x33, 0x99, 0xdc, 0x23, 0x99, 0x69, 0xdc, 0x23, 0x22, 0x62,
0xaa, 0x6a, 0x49, 0x29, 0xdd, 0xbd, 0x76, 0x24, 0x33, 0x33, 0x96, 0x27, 0x33, 0x33, 0x99, 0x27,
0x22, 0x62, 0x96, 0x27, 0x69, 0x26, 0x9a, 0x27, 0x66, 0x2b, 0x9b, 0x27, 0x26, 0x22, 0x9b, 0x27,
0xaa, 0x6a, 0x49, 0x29, 0xdd, 0xbd, 0x76, 0x24, 0x33, 0x33, 0x96, 0x27, 0x33, 0x33, 0x99, 0x27,
0x22, 0x62, 0x96, 0x27, 0x69, 0x26, 0x9a, 0x27, 0x66, 0x2b, 0x9b, 0x27, 0x22, 0xb2, 0x9b, 0x27,
0xaa, 0x6a, 0x49, 0x29, 0xdd, 0xbd, 0x76, 0x24, 0x33, 0x33, 0x96, 0x27, 0x33, 0x33, 0x99, 0x27,
0x32, 0x26, 0x96, 0x27, 0x62, 0x26, 0x9a, 0x27, 0x62, 0x2b, 0x9b, 0x27, 0x26, 0x22, 0x9b, 0x27,
0xaa, 0x6a, 0x49, 0x29, 0xdd, 0xbd, 0x76, 0x24, 0x33, 0x33, 0x96, 0x27, 0x33, 0x33, 0x99, 0x27,
0x22, 0x22, 0x96, 0x27, 0x62, 0xa6, 0x9a, 0x27, 0x62, 0xba, 0x9b, 0x27, 0x22, 0xb2, 0x9b, 0x27,
0x49, 0xdc, 0xaa, 0xaa, 0x14, 0xd1, 0xdd, 0xdd, 0x11, 0x3d, 0x77, 0x37, 0xc1, 0x77, 0x77, 0x33,
0xdc, 0x27, 0x22, 0x32, 0xdc, 0x27, 0x33, 0x33, 0xdc, 0x27, 0x93, 0x99, 0xdc, 0x23, 0x22, 0x62,
0xaa, 0x6a, 0x49, 0x29, 0xdd, 0xbd, 0x76, 0x24, 0x37, 0x33, 0x96, 0x27, 0x33, 0x33, 0x99, 0x27,
0x23, 0x62, 0x96, 0x27, 0x92, 0x66, 0x96, 0x27, 0x62, 0xba, 0x9b, 0x27, 0x22, 0xb2, 0x9b, 0x27,
0x49, 0xdc, 0xaa, 0xaa, 0x14, 0xd1, 0xdd, 0xdd, 0x11, 0x3d, 0x77, 0x37, 0xc1, 0x77, 0x77, 0x33,
0xdc, 0x27, 0x22, 0x32, 0xdc, 0x27, 0x33, 0x33, 0xdc, 0x27, 0x93, 0x69, 0xdc, 0x23, 0x22, 0x62,
0xaa, 0x6a, 0x49, 0x29, 0xdd, 0xbd, 0x76, 0x24, 0x37, 0x33, 0x96, 0x27, 0x33, 0x33, 0x99, 0x27,
0x22, 0x22, 0x96, 0x27, 0x99, 0x26, 0x9a, 0x27, 0x66, 0x2a, 0x9b, 0x27, 0xa6, 0xb2, 0x9b, 0x27,
0xaa, 0x6a, 0x49, 0x29, 0xdd, 0xbd, 0x76, 0x24, 0x37, 0x33, 0x96, 0x27, 0x33, 0x33, 0x99, 0x27,
0x23, 0x62, 0x96, 0x27, 0x92, 0x26, 0x96, 0x27, 0x62, 0x2a, 0x9b, 0x27, 0x26, 0xb2, 0x9b, 0x27,
0xaa, 0x6a, 0x49, 0x29, 0xdd, 0xbd, 0x76, 0x24, 0x37, 0x33, 0x96, 0x27, 0x33, 0x33, 0x99, 0x27,
0x23, 0x62, 0x96, 0x27, 0x92, 0x26, 0x96, 0x27, 0x62, 0x2a, 0x9b, 0x27, 0x26, 0x22, 0x9b, 0x27,
0x49, 0xdc, 0xaa, 0xaa, 0x14, 0xd1, 0xdd, 0xdd, 0x11, 0x3d, 0x77, 0x37, 0xc1, 0x77, 0x77, 0x33,
0x2c, 0x22, 0x32, 0x22, 0x2c, 0x77, 0x33, 0x23, 0x2c, 0x37, 0x93, 0x29, 0x2c, 0x22, 0x32, 0x26,
0xaa, 0x6a, 0x49, 0x29, 0xdd, 0xbd, 0x76, 0x24, 0x37, 0x33, 0x96, 0x27, 0x33, 0x33, 0x99, 0x27,
0x33, 0x22, 0x92, 0x27, 0x29, 0x66, 0x22, 0x27, 0x26, 0x2a, 0x2b, 0x27, 0x26, 0x2b, 0x2b, 0x27,
0x49, 0xdc, 0xaa, 0xaa, 0x14, 0xd1, 0xdd, 0xdd, 0x11, 0x3d, 0x77, 0x37, 0xc1, 0x77, 0x77, 0x33,
0x2c, 0x22, 0x32, 0x23, 0x2c, 0x77, 0x33, 0x33, 0x2c, 0x37, 0x93, 0x99, 0x2c, 0x22, 0x32, 0x66,
0xaa, 0x6a, 0x49, 0x29, 0xdd, 0xbd, 0x76, 0x24, 0x37, 0x33, 0x96, 0x27, 0x33, 0x33, 0x99, 0x27,
0x32, 0x23, 0x92, 0x27, 0x62, 0x66, 0x92, 0x27, 0x62, 0xba, 0x92, 0x27, 0xa2, 0xbb, 0x92, 0x27,
0xaa, 0x6a, 0x49, 0x29, 0xdd, 0xbd, 0x76, 0x24, 0x37, 0x33, 0x96, 0x27, 0x33, 0x33, 0x99, 0x24,
0x32, 0x22, 0x92, 0x24, 0x92, 0x66, 0x2a, 0x24, 0x62, 0xba, 0x2b, 0x24, 0xa2, 0x2b, 0x22, 0x24,
0x49, 0xc1, 0xdd, 0xdd, 0x14, 0xd1, 0xdd, 0xdd, 0x11, 0x3c, 0x77, 0x37, 0xc1, 0x77, 0x77, 0x33,
0xcc, 0x77, 0x22, 0x33, 0xdc, 0x77, 0x22, 0x32, 0xcc, 0x37, 0x23, 0x22, 0xdc, 0x33, 0x99, 0x22,
0xdd, 0x6d, 0x49, 0x29, 0xdd, 0xbd, 0x76, 0x24, 0x37, 0x33, 0x96, 0x27, 0x33, 0x33, 0x93, 0x24,
0x23, 0x62, 0x96, 0x24, 0x22, 0x62, 0x9a, 0x24, 0x22, 0xba, 0x9b, 0x24, 0xa2, 0xbb, 0x9b, 0x24,
0x66, 0x66, 0x66, 0x29, 0x66, 0x66, 0x96, 0x29, 0x66, 0x66, 0x96, 0x29, 0x66, 0x66, 0x99, 0x29,
0x66, 0x66, 0x96, 0x29, 0x66, 0x66, 0x96, 0x29, 0x66, 0x66, 0x96, 0x29, 0x66, 0x66, 0x99, 0x29,
0x92, 0x69, 0x66, 0x26, 0x92, 0x99, 0x66, 0x26, 0x92, 0x69, 0x66, 0x26, 0x92, 0x69, 0x66, 0x26,
0x92, 0x69, 0x66, 0x26, 0x92, 0x99, 0x66, 0x26, 0x92, 0x69, 0x66, 0x26, 0x92, 0x99, 0x66, 0x26,
0xcc, 0x92, 0x66, 0xa6, 0xdc, 0x22, 0x62, 0x22, 0xcc, 0x93, 0x66, 0xba, 0xdc, 0x37, 0x66, 0xaa,
0x66, 0x36, 0x63, 0xa6, 0x94, 0x69, 0x99, 0x99, 0x49, 0x99, 0x77, 0x77, 0x22, 0x22, 0x22, 0x22,
0xb2, 0xd2, 0x9d, 0x24, 0xdb, 0x2d, 0x92, 0x24, 0xdb, 0xdd, 0x9d, 0x24, 0xbb, 0xdd, 0x9b, 0x24,
0xba, 0xbb, 0x79, 0x24, 0x99, 0x99, 0x47, 0x24, 0x77, 0x77, 0x44, 0x29, 0x22, 0x22, 0x22, 0x22,
0x66, 0x66, 0x66, 0x26, 0x66, 0x66, 0x66, 0x26, 0x66, 0x66, 0x66, 0x26, 0x66, 0x66, 0x66, 0x26,
0x66, 0x66, 0x66, 0x26, 0x66, 0x66, 0x66, 0x26, 0x66, 0x66, 0x66, 0x26, 0x22, 0x22, 0x22, 0x22,
0xcc, 0x23, 0x69, 0x66, 0xdc, 0x27, 0x66, 0xa6, 0xdc, 0x27, 0x69, 0xa6, 0xdc, 0x33, 0x63, 0xa6,
0x66, 0x36, 0x33, 0x63, 0x94, 0x69, 0x99, 0x99, 0x49, 0x79, 0x77, 0x77, 0x22, 0x22, 0x22, 0x22,
0xba, 0xd2, 0x9b, 0x27, 0xdb, 0xd2, 0x9d, 0x27, 0xdb, 0xd2, 0x9b, 0x27, 0xbb, 0xbb, 0x9d, 0x27,
0x66, 0xba, 0x79, 0x24, 0x99, 0x99, 0x47, 0x24, 0x77, 0x77, 0x47, 0x29, 0x22, 0x22, 0x22, 0x22,
0xcc, 0x23, 0x69, 0x66, 0xdc, 0x27, 0x66, 0xa6, 0xdc, 0x27, 0x69, 0xa6, 0xdc, 0x33, 0x63, 0xb6,
0x66, 0x36, 0x33, 0x93, 0x94, 0x69, 0x99, 0x99, 0x49, 0x79, 0x77, 0x77, 0x22, 0x22, 0x22, 0x22,
0xb2, 0xdd, 0x9d, 0x27, 0xd2, 0xdd, 0x9b, 0x27, 0x22, 0x22, 0x9d, 0x27, 0xbb, 0xbb, 0x9b, 0x27,
0x66, 0xba, 0x79, 0x24, 0x99, 0x99, 0x47, 0x24, 0x77, 0x77, 0x47, 0x29, 0x22, 0x22, 0x22, 0x22,
0xba, 0x2d, 0x9d, 0x27, 0xdb, 0x2d, 0x9b, 0x27, 0x22, 0xd2, 0x9d, 0x27, 0xbb, 0xbb, 0x9b, 0x27,
0x66, 0xba, 0x79, 0x24, 0x99, 0x99, 0x47, 0x24, 0x77, 0x77, 0x47, 0x29, 0x22, 0x22, 0x22, 0x22,
0xba, 0x2d, 0x9d, 0x27, 0xdb, 0x2d, 0x9b, 0x27, 0xdb, 0x2d, 0x9d, 0x27, 0xbb, 0xbb, 0x9b, 0x27,
0x66, 0xba, 0x79, 0x24, 0x99, 0x99, 0x47, 0x24, 0x77, 0x77, 0x47, 0x29, 0x22, 0x22, 0x22, 0x22,
0xcc, 0x23, 0x99, 0x66, 0xdc, 0x23, 0x66, 0x66, 0xdc, 0x23, 0x69, 0xa6, 0xdc, 0x37, 0x66, 0xa6,
0x66, 0x36, 0x63, 0xa6, 0x94, 0x69, 0x99, 0x99, 0x49, 0x79, 0x77, 0x77, 0x22, 0x22, 0x22, 0x22,
0xb2, 0x2d, 0x9d, 0x27, 0xb2, 0x2d, 0x9d, 0x27, 0x2b, 0xd2, 0x9d, 0x27, 0xbb, 0xdd, 0x9b, 0x27,
0xaa, 0xbb, 0x79, 0x24, 0x99, 0x99, 0x47, 0x24, 0x77, 0x77, 0x47, 0x29, 0x22, 0x22, 0x22, 0x22,
0x26, 0xdd, 0x9d, 0x27, 0x2b, 0xdd, 0x9d, 0x27, 0x2b, 0xdd, 0x9d, 0x27, 0xbb, 0xdd, 0x9b, 0x27,
0xaa, 0xbb, 0x79, 0x24, 0x99, 0x99, 0x47, 0x24, 0x77, 0x77, 0x47, 0x29, 0x22, 0x22, 0x22, 0x22,
0xb6, 0x2d, 0x9d, 0x27, 0xbb, 0x2d, 0x9d, 0x27, 0x2b, 0xd2, 0x9d, 0x27, 0xbb, 0xdd, 0x9b, 0x27,
0xaa, 0xbb, 0x79, 0x24, 0x99, 0x99, 0x47, 0x24, 0x77, 0x77, 0x47, 0x29, 0x22, 0x22, 0x22, 0x22,
0x2c, 0x93, 0x69, 0x26, 0x2c, 0x93, 0x69, 0x26, 0x2c, 0x93, 0x66, 0x26, 0xdd, 0x37, 0x66, 0xa6,
0x66, 0x36, 0x63, 0xa6, 0x94, 0x69, 0x99, 0x99, 0x49, 0x79, 0x77, 0x77, 0x22, 0x22, 0x22, 0x22,
0x2a, 0x2d, 0x2d, 0x27, 0x2b, 0xd2, 0x2d, 0x27, 0xdb, 0x22, 0x92, 0x27, 0xbb, 0xdd, 0x9b, 0x27,
0xaa, 0xbb, 0x79, 0x24, 0x99, 0x99, 0x47, 0x24, 0x77, 0x77, 0x47, 0x29, 0x22, 0x22, 0x22, 0x22,
0x2c, 0x93, 0x69, 0x66, 0x2c, 0x93, 0x69, 0x66, 0x2c, 0x93, 0x66, 0xa6, 0xdd, 0x37, 0x66, 0xa6,
0x66, 0x36, 0x63, 0xa6, 0x94, 0x69, 0x99, 0x99, 0x49, 0x79, 0x77, 0x77, 0x22, 0x22, 0x22, 0x22,
0xb2, 0xdd, 0x92, 0x27, 0xb2, 0xdd, 0x92, 0x27, 0xd2, 0xdd, 0x92, 0x27, 0xbb, 0xdd, 0x9b, 0x27,
0xba, 0xbb, 0x79, 0x24, 0x99, 0x99, 0x47, 0x24, 0x77, 0x77, 0x44, 0x29, 0x22, 0x22, 0x22, 0x22,
0x2c, 0x93, 0x69, 0x66, 0x2c, 0x93, 0x69, 0x66, 0x2c, 0x93, 0x66, 0xa6, 0xdd, 0x37, 0x66, 0xa6,
0x66, 0x36, 0x63, 0xa6, 0x94, 0x69, 0x99, 0x99, 0x49, 0x99, 0x77, 0x77, 0x22, 0x22, 0x22, 0x22,
0xb2, 0xd2, 0x9d, 0x24, 0xb2, 0xd2, 0x9d, 0x24, 0xd2, 0x22, 0x22, 0x24, 0xbb, 0xdd, 0x9b, 0x24,
0xaa, 0xbb, 0x79, 0x24, 0x99, 0x99, 0x47, 0x24, 0x77, 0x77, 0x47, 0x29, 0x22, 0x22, 0x22, 0x22,
0xcc, 0x93, 0x29, 0x22, 0xdc, 0x93, 0x22, 0xa2, 0xcc, 0x93, 0x22, 0xa6, 0xdc, 0x37, 0x66, 0xa6,
0x66, 0x36, 0x63, 0xa6, 0x94, 0x69, 0x99, 0x99, 0x49, 0x99, 0x77, 0x77, 0x22, 0x22, 0x22, 0x22,
0x22, 0xdd, 0x9d, 0x24, 0x22, 0xd2, 0x9d, 0x24, 0x2b, 0xd2, 0x9d, 0x24, 0xbb, 0xdd, 0x9b, 0x24,
0xaa, 0xab, 0x79, 0x24, 0x99, 0x99, 0x47, 0x24, 0x77, 0x77, 0x44, 0x29, 0x22, 0x22, 0x22, 0x22,
0x66, 0x66, 0x96, 0x29, 0x66, 0x66, 0x99, 0x29, 0x66, 0x66, 0x96, 0x29, 0x66, 0x66, 0x96, 0x29,
0x66, 0x66, 0x99, 0x29, 0x66, 0x66, 0x96, 0x29, 0x66, 0x66, 0x96, 0x29, 0x66, 0x66, 0x99, 0x29,
0x92, 0x69, 0x66, 0x26, 0x92, 0x69, 0x66, 0x26, 0x92, 0x99, 0x66, 0x26, 0x92, 0x69, 0x66, 0x26,
0x92, 0x69, 0x66, 0x26, 0x92, 0x99, 0x66, 0x26, 0x92, 0x69, 0x66, 0x26, 0x92, 0x69, 0x66, 0x26,
0x49, 0xc1, 0xcc, 0xcc, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0x22,
0xc1, 0x69, 0xa6, 0x2a, 0xc1, 0xa9, 0xaa, 0x2b, 0xc1, 0x66, 0xba, 0x2d, 0xc1, 0xaa, 0xbb, 0x2d,
0xcc, 0xdc, 0x4a, 0x29, 0xcc, 0xcc, 0x6b, 0x24, 0xa6, 0xba, 0xad, 0x26, 0xba, 0xbb, 0xad, 0x29,
0xbb, 0xdd, 0xad, 0x29, 0xdd, 0xdd, 0xad, 0x29, 0xdd, 0xdc, 0xac, 0x29, 0xdd, 0xcd, 0xad, 0x29,
0x49, 0xc1, 0xdd, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x26, 0x22,
0xc1, 0x69, 0xa6, 0xba, 0xc1, 0xa9, 0xaa, 0xbb, 0xc1, 0x66, 0xba, 0xdd, 0xc1, 0xaa, 0xbb, 0x22,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0xb2, 0xdb, 0xad, 0x29,
0x2b, 0xdd, 0xad, 0x29, 0x2d, 0xdd, 0xad, 0x29, 0x2d, 0xdc, 0xac, 0x29, 0xd2, 0xcd, 0xad, 0x29,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x26, 0x22,
0xc1, 0x69, 0xa6, 0xba, 0xc1, 0xa9, 0xaa, 0xbb, 0xc1, 0x66, 0xba, 0xdd, 0xc1, 0xaa, 0xbb, 0x22,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x26, 0xaa,
0xc1, 0x69, 0x26, 0xaa, 0xc1, 0xa9, 0x2a, 0xbb, 0xc1, 0x66, 0x2a, 0xdd, 0xc1, 0xaa, 0x2b, 0xdd,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0x2a, 0xdb, 0xad, 0x29,
0x2b, 0xdd, 0xad, 0x29, 0x2d, 0xdd, 0xad, 0x29, 0x2d, 0xdc, 0xac, 0x29, 0x2d, 0xcd, 0xad, 0x29,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x26, 0x22,
0xc1, 0x69, 0x26, 0xba, 0xc1, 0xa9, 0x2a, 0xbb, 0xc1, 0x66, 0x2a, 0xdd, 0xc1, 0xaa, 0x2b, 0x22,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0x22, 0xdb, 0xad, 0x29,
0xbb, 0xdd, 0xad, 0x29, 0xdd, 0xdd, 0xad, 0x29, 0xdd, 0xdc, 0xac, 0x29, 0xd2, 0xcd, 0xad, 0x29,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0x22,
0xc1, 0x69, 0x26, 0xba, 0xc1, 0xa9, 0x2a, 0xbb, 0xc1, 0x66, 0x2a, 0xdd, 0xc1, 0xaa, 0x2b, 0x22,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0xb2, 0xdb, 0xad, 0x29,
0xbb, 0xdd, 0xad, 0x29, 0xdd, 0xdd, 0xad, 0x29, 0xdd, 0xdc, 0xac, 0x29, 0xd2, 0xcd, 0xad, 0x29,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x26, 0x22,
0xc1, 0x69, 0xa6, 0xba, 0xc1, 0xa9, 0xaa, 0xbb, 0xc1, 0x66, 0xba, 0xdd, 0xc1, 0xaa, 0xbb, 0x2d,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0x22, 0xdb, 0xad, 0x29,
0x2b, 0xdd, 0xad, 0x29, 0x2d, 0xdd, 0xad, 0x29, 0xd2, 0xdc, 0xac, 0x29, 0xdd, 0xcd, 0xad, 0x29,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0x22,
0xc1, 0x69, 0x26, 0xba, 0xc1, 0xa9, 0x2a, 0xbb, 0xc1, 0x66, 0x2a, 0xdd, 0xc1, 0xaa, 0xbb, 0x22,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0xb2, 0xdb, 0xad, 0x29,
0x2b, 0xdd, 0xad, 0x29, 0x2d, 0xdd, 0xad, 0x29, 0x2d, 0xdc, 0xac, 0x29, 0x22, 0xcd, 0xad, 0x29,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0x22,
0xc1, 0x69, 0x26, 0xba, 0xc1, 0xa9, 0x2a, 0xbb, 0xc1, 0x66, 0x2a, 0xdd, 0xc1, 0xaa, 0x2b, 0x2d,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0xb2, 0xdb, 0xad, 0x29,
0x2b, 0xdd, 0xad, 0x29, 0x22, 0xdd, 0xad, 0x29, 0x22, 0xdc, 0xac, 0x29, 0x2d, 0xcd, 0xad, 0x29,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0xaa,
0xc1, 0x69, 0xa6, 0xaa, 0xc1, 0xa9, 0xaa, 0xbb, 0xc1, 0x66, 0xba, 0xdd, 0xc1, 0xaa, 0x2a, 0x22,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0xba, 0xdb, 0xad, 0x29,
0xbb, 0xdd, 0xad, 0x29, 0xdd, 0xdd, 0xad, 0x29, 0xdd, 0xdc, 0xac, 0x29, 0x22, 0xcd, 0xad, 0x29,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0xaa,
0xc1, 0x69, 0xa6, 0xaa, 0xc1, 0xa9, 0xaa, 0xbb, 0xc1, 0x66, 0x2a, 0x22, 0xc1, 0xaa, 0xbb, 0xdd,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x29, 0xba, 0xdb, 0xad, 0x27,
0xbb, 0xdd, 0xad, 0x27, 0xdd, 0xdd, 0xad, 0x27, 0x22, 0xdc, 0xac, 0x27, 0xdd, 0xcd, 0xad, 0x27,
0x49, 0xc1, 0xdd, 0xdd, 0x14, 0xd1, 0xdd, 0xdd, 0x11, 0x3c, 0x77, 0x77, 0xcc, 0x77, 0x77, 0x33,
0xcc, 0x77, 0x37, 0x33, 0xdc, 0x77, 0x37, 0x33, 0xdc, 0x77, 0x33, 0x39, 0xcc, 0x37, 0x93, 0x69,
0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0x73, 0x37, 0x77, 0x73, 0x37, 0x73, 0x33, 0x37,
0x33, 0x33, 0x32, 0x33, 0x33, 0x23, 0x32, 0x33, 0x96, 0x22, 0x22, 0x22, 0x26, 0x22, 0x22, 0x22,
0xdd, 0xdd, 0x6a, 0xa6, 0xdd, 0xdd, 0xdd, 0xdd, 0x37, 0x77, 0x73, 0x37, 0x73, 0x33, 0x37, 0x33,
0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x22, 0x22, 0x22, 0x36, 0x22, 0x22, 0x22, 0x63,
0xaa, 0x6a, 0x49, 0x29, 0xdd, 0xbd, 0x76, 0x24, 0x37, 0x33, 0x96, 0x27, 0x33, 0x33, 0x93, 0x24,
0x33, 0x63, 0x96, 0x24, 0x63, 0x66, 0x96, 0x24, 0x66, 0xaa, 0x9b, 0x24, 0xa6, 0xbb, 0x9b, 0x24,
0x49, 0xc1, 0xdd, 0xdd, 0x14, 0xd1, 0xdd, 0xdd, 0x11, 0x3c, 0x77, 0x37, 0xc1, 0x77, 0x77, 0x33,
0xcc, 0x77, 0x33, 0x33, 0xd2, 0x72, 0x23, 0x33, 0xc2, 0x32, 0x92, 0x92, 0x22, 0x32, 0x92, 0x62,
0xdd, 0x6d, 0x49, 0x29, 0xdd, 0xbd, 0x76, 0x24, 0x37, 0x33, 0x96, 0x27, 0x33, 0x33, 0x93, 0x24,
0x33, 0x63, 0x96, 0x24, 0x62, 0x62, 0x22, 0x24, 0x22, 0xb2, 0x92, 0x24, 0x22, 0xb2, 0x22, 0x24,
0x66, 0x66, 0x96, 0x29, 0x66, 0x66, 0x96, 0x29, 0x66, 0x66, 0x96, 0x29, 0x66, 0x66, 0x99, 0x29,
0x66, 0x66, 0x96, 0x29, 0x66, 0x66, 0x99, 0x29, 0x66, 0x66, 0x96, 0x29, 0x66, 0x66, 0x96, 0x29,
0x92, 0x69, 0x66, 0x26, 0x92, 0x69, 0x66, 0x26, 0x92, 0x99, 0x66, 0x26, 0x92, 0x69, 0x66, 0x26,
0x92, 0x69, 0x66, 0x26, 0x92, 0x69, 0x66, 0x26, 0x92, 0x69, 0x66, 0x26, 0x92, 0x69, 0x66, 0x26,
0xc1, 0xaa, 0xbb, 0x2d, 0xc1, 0xba, 0xdb, 0x2d, 0xc1, 0xba, 0xdd, 0x2d, 0xcc, 0xb6, 0xdd, 0x2d,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6a, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xcd, 0xdc, 0xac, 0x29, 0xcd, 0xcc, 0xad, 0x29, 0xcd, 0xcd, 0xac, 0x29, 0xdc, 0xcc, 0xad, 0x29,
0xcd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0x2b, 0xdd, 0xc1, 0xba, 0x2b, 0xdd, 0xc1, 0xb6, 0x2d, 0xdc, 0xcc, 0xba, 0x2d, 0x22,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xcd, 0xdc, 0xac, 0x29, 0xdc, 0xcc, 0xad, 0x29, 0xcd, 0xcd, 0xac, 0x29, 0x22, 0xcc, 0xad, 0x29,
0xcd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xbb, 0xdd, 0xc1, 0xba, 0xdb, 0xdd, 0xc1, 0xba, 0xdd, 0xcd, 0xcc, 0xb6, 0x2d, 0x22,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0x2d, 0xdc, 0xac, 0x29, 0x2c, 0xcc, 0xad, 0x29, 0x2d, 0xcd, 0xac, 0x29, 0xc2, 0xcc, 0xad, 0x29,
0xdd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xbb, 0x22, 0xc1, 0xba, 0xdb, 0xdd, 0xc1, 0xba, 0xdd, 0xdd, 0xcc, 0xb6, 0xdd, 0xcd,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0x22, 0xdc, 0xac, 0x29, 0x2d, 0xcc, 0xad, 0x29, 0x2c, 0xcd, 0xac, 0x29, 0x2d, 0xcc, 0xad, 0x29,
0xdc, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0x2b, 0xdd, 0xc1, 0xba, 0x2b, 0xdd, 0xc1, 0xb6, 0x2d, 0xcd, 0xcc, 0xba, 0xdd, 0x22,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xbb, 0x2d, 0xc1, 0xba, 0xdb, 0x2d, 0xc1, 0xba, 0xdd, 0x2d, 0xcc, 0xb6, 0xdd, 0x2d,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xbb, 0xdd, 0xc1, 0xba, 0xdb, 0xdd, 0xc1, 0xba, 0xdd, 0xcd, 0xcc, 0xb6, 0xdd, 0x22,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0x2b, 0xd2, 0xc1, 0xba, 0x2b, 0xd2, 0xc1, 0xb6, 0x2d, 0xcd, 0xcc, 0xba, 0xdd, 0x22,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xbb, 0xdd, 0xc1, 0xba, 0xdb, 0xdd, 0xc1, 0xba, 0xdd, 0xdc, 0xcc, 0xb6, 0xdd, 0xdd,
0xdd, 0xbd, 0xdb, 0xcd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xcd, 0xdc, 0xac, 0x29, 0xdc, 0xcc, 0xad, 0x29, 0xcd, 0xcd, 0xac, 0x29, 0xdc, 0xcc, 0xad, 0x29,
0xdd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0x2b, 0x22, 0xc1, 0xba, 0xdb, 0xdd, 0xc1, 0xba, 0xdd, 0xcd, 0xcc, 0xb6, 0xdd, 0xdd,
0xdd, 0xbd, 0xdb, 0xcd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0x22, 0xdc, 0xac, 0x27, 0xcd, 0xcc, 0xad, 0x27, 0xcd, 0xcd, 0xac, 0x27, 0xdc, 0xcc, 0xad, 0x27,
0xdd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xdc, 0x37, 0x99, 0x66, 0xcc, 0x77, 0x63, 0x66, 0xdc, 0x37, 0x33, 0xa6, 0xdc, 0x33, 0x33, 0x93,
0x66, 0x36, 0x33, 0x63, 0x94, 0x69, 0x99, 0x99, 0x49, 0x99, 0x77, 0x77, 0x22, 0x22, 0x22, 0x22,
0x66, 0x22, 0x22, 0x22, 0x66, 0x2a, 0xa2, 0xa6, 0xaa, 0xaa, 0xa2, 0xaa, 0x66, 0x66, 0xaa, 0xaa,
0x93, 0x96, 0x39, 0x96, 0x99, 0x99, 0x99, 0x99, 0x77, 0x77, 0x77, 0x77, 0x22, 0x22, 0x22, 0x22,
0x22, 0x22, 0x22, 0x66, 0xa6, 0xa6, 0xa6, 0xa6, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x66, 0x66,
0x36, 0x39, 0x96, 0x69, 0x99, 0x99, 0x99, 0x99, 0x77, 0x77, 0x77, 0x77, 0x22, 0x22, 0x22, 0x22,
0xb6, 0xdb, 0x9b, 0x24, 0xba, 0xdd, 0x9b, 0x24, 0xbb, 0xbb, 0x9d, 0x24, 0xa6, 0xbb, 0x9b, 0x24,
0x66, 0xba, 0x79, 0x24, 0x99, 0x99, 0x47, 0x24, 0x77, 0x77, 0x44, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc2, 0x92, 0x92, 0x62, 0xd2, 0x92, 0x26, 0x66, 0xcc, 0x93, 0x69, 0xa6, 0xdc, 0x33, 0x66, 0xa6,
0x66, 0x36, 0x63, 0xa6, 0x94, 0x69, 0x99, 0x99, 0x49, 0x99, 0x77, 0x77, 0x22, 0x22, 0x22, 0x22,
0xb2, 0xd2, 0x92, 0x24, 0xb2, 0xd2, 0x22, 0x24, 0xdb, 0xdd, 0x9d, 0x24, 0xbb, 0xdd, 0x9b, 0x24,
0xba, 0xba, 0x79, 0x24, 0x99, 0x99, 0x47, 0x24, 0x77, 0x77, 0x44, 0x29, 0x22, 0x22, 0x22, 0x22,
0x66, 0x66, 0x99, 0x29, 0x66, 0x66, 0x96, 0x29, 0x66, 0x66, 0x96, 0x29, 0x66, 0x66, 0x99, 0x29,
0x66, 0x66, 0x96, 0x29, 0x66, 0x66, 0x96, 0x29, 0x66, 0x66, 0x96, 0x29, 0x66, 0x66, 0x96, 0x29,
0x92, 0x69, 0x66, 0x2a, 0x92, 0x69, 0x66, 0x26, 0x92, 0x69, 0xa6, 0x26, 0x9f, 0xa9, 0x66, 0x26,
0x92, 0xa9, 0xa6, 0x26, 0x9f, 0x69, 0xa6, 0x2a, 0x9f, 0xa9, 0x66, 0x2a, 0x9f, 0xa9, 0xa6, 0x2a,
0x49, 0xd1, 0x49, 0x29, 0x14, 0xd1, 0x76, 0x24, 0x11, 0x9c, 0x96, 0x27, 0xcc, 0x33, 0x93, 0x27,
0xcc, 0x32, 0x93, 0x22, 0xdc, 0x22, 0x96, 0x22, 0x22, 0x22, 0x92, 0x22, 0x22, 0x22, 0x22, 0x22,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0xaa,
0xc1, 0x69, 0xa6, 0xaa, 0xc1, 0xa9, 0xaa, 0x22, 0xc1, 0x66, 0x2a, 0xdd, 0xc1, 0xaa, 0x2a, 0xdd,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0xba, 0xdb, 0xad, 0x29,
0xbb, 0xdd, 0xad, 0x29, 0x22, 0xdd, 0xad, 0x29, 0x2d, 0xdc, 0xac, 0x29, 0x2d, 0xcd, 0xad, 0x29,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0xaa,
0xc1, 0x69, 0xa6, 0xaa, 0xc1, 0xa9, 0x2a, 0xbb, 0xc1, 0x66, 0x2a, 0x2d, 0xc1, 0xaa, 0x2b, 0x2d,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0xba, 0xdb, 0xad, 0x29,
0xbb, 0xdd, 0xad, 0x29, 0x2d, 0xdd, 0xad, 0x29, 0x2d, 0xdc, 0xac, 0x29, 0x2d, 0xcd, 0xad, 0x29,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0xaa,
0xc1, 0x69, 0xa6, 0xaa, 0xc1, 0xa9, 0xaa, 0x22, 0xc1, 0x66, 0x2a, 0xdd, 0xc1, 0xaa, 0x2a, 0x22,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0xba, 0xdb, 0xad, 0x29,
0xbb, 0xdd, 0xad, 0x29, 0xd2, 0xdd, 0xad, 0x29, 0x2d, 0xdc, 0xac, 0x29, 0x22, 0xcd, 0xad, 0x29,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0xaa,
0xc1, 0x69, 0xa6, 0xaa, 0xc1, 0xa9, 0x2a, 0x2b, 0xc1, 0x66, 0x2a, 0xd2, 0xc1, 0xaa, 0x2b, 0xdd,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0xba, 0xdb, 0xad, 0x29,
0xbb, 0xdd, 0xad, 0x29, 0xd2, 0xdd, 0xad, 0x29, 0xdd, 0xdc, 0xac, 0x29, 0xdd, 0xcd, 0xad, 0x29,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0xa2,
0xc1, 0x69, 0xa6, 0xb2, 0xc1, 0xa9, 0x2a, 0x22, 0xc1, 0x66, 0xba, 0xd2, 0xc1, 0xaa, 0xbb, 0xd2,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0xaa,
0xc1, 0x69, 0xa6, 0xaa, 0xc1, 0xa9, 0x2a, 0xbb, 0xc1, 0x66, 0x2a, 0xdd, 0xc1, 0xaa, 0xbb, 0xd2,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0xba, 0xdb, 0xad, 0x29,
0xbb, 0xdd, 0xad, 0x29, 0x2d, 0xdd, 0xad, 0x29, 0x2d, 0xdc, 0xac, 0x29, 0xd2, 0xcd, 0xad, 0x29,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0xaa,
0xc1, 0x69, 0xa6, 0xaa, 0xc1, 0xa9, 0x2a, 0xbb, 0xc1, 0x66, 0x2a, 0xdd, 0xc1, 0xaa, 0x2b, 0xdd,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0x2a,
0xc1, 0x69, 0xa6, 0xaa, 0xc1, 0xa9, 0xaa, 0x2b, 0xc1, 0x66, 0xba, 0x2d, 0xc1, 0xaa, 0xbb, 0x2d,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0xba, 0xdb, 0xad, 0x29,
0xbb, 0xdd, 0xad, 0x29, 0xdd, 0xdd, 0xad, 0x29, 0xdd, 0xdc, 0xac, 0x29, 0xdd, 0xcd, 0xad, 0x29,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0xba, 0xdb, 0xad, 0x29,
0xbb, 0xdd, 0xad, 0x29, 0xd2, 0xdd, 0xad, 0x29, 0x2d, 0xdc, 0xac, 0x29, 0x2d, 0xcd, 0xad, 0x29,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0xaa,
0xc1, 0x69, 0xa6, 0xaa, 0xc1, 0xa9, 0x2a, 0x22, 0xc1, 0x66, 0x2a, 0xdd, 0xc1, 0xaa, 0x2b, 0xdd,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0x22,
0xc1, 0x69, 0xa6, 0xb2, 0xc1, 0xa9, 0xaa, 0xb2, 0xc1, 0x66, 0xba, 0xd2, 0xc1, 0xaa, 0xbb, 0xd2,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0xb2, 0xdb, 0xad, 0x29,
0xbb, 0xdd, 0xad, 0x29, 0xdd, 0xdd, 0xad, 0x29, 0xdd, 0xdc, 0xac, 0x29, 0xdd, 0xcd, 0xad, 0x29,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0x22,
0xc1, 0x69, 0xa6, 0xba, 0xc1, 0xa9, 0xaa, 0xbb, 0xc1, 0x66, 0xba, 0xdd, 0xc1, 0xaa, 0xbb, 0xdd,
0xdd, 0xdd, 0x4b, 0x29, 0xcc, 0xcc, 0x6b, 0x24, 0xa6, 0xba, 0xad, 0x26, 0xb2, 0xbb, 0xad, 0x29,
0xb2, 0xdd, 0xad, 0x29, 0xd2, 0xdd, 0xad, 0x29, 0xd2, 0xdc, 0xac, 0x29, 0xd2, 0xcd, 0xad, 0x29,
0x49, 0xc1, 0xcc, 0xcc, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0xa2,
0xc1, 0x69, 0xa6, 0xb2, 0xc1, 0xa9, 0xaa, 0xb2, 0xc1, 0x66, 0xba, 0x2d, 0xc1, 0xaa, 0xbb, 0x2d,
0xcc, 0xdc, 0x4b, 0x29, 0xcc, 0xcc, 0x6b, 0x24, 0xa6, 0xba, 0xad, 0x29, 0xba, 0xbb, 0xad, 0x27,
0xbb, 0xdd, 0xad, 0x27, 0xdd, 0xdd, 0xad, 0x27, 0xdd, 0xdc, 0xac, 0x27, 0xdd, 0xcd, 0xad, 0x27,
0x49, 0xc1, 0xdd, 0xdd, 0x14, 0xd1, 0xdd, 0xdd, 0x11, 0x3c, 0x77, 0x37, 0xc1, 0x77, 0x77, 0x33,
0xcc, 0x77, 0x33, 0x33, 0x22, 0x77, 0x23, 0x33, 0xd2, 0x32, 0x92, 0x92, 0x22, 0x39, 0x92, 0x69,
0xdd, 0x6d, 0x49, 0x29, 0xdd, 0xbd, 0x76, 0x24, 0x37, 0x33, 0x96, 0x27, 0x33, 0x33, 0x93, 0x24,
0x33, 0x63, 0x96, 0x24, 0x62, 0x62, 0x22, 0x24, 0x62, 0xb2, 0x92, 0x22, 0xa2, 0xb2, 0x22, 0x24,
0x66, 0x66, 0x96, 0x29, 0x66, 0x66, 0x96, 0x29, 0xa6, 0x66, 0x96, 0x29, 0x66, 0x66, 0x96, 0x29,
0x66, 0x6a, 0x96, 0x29, 0x66, 0x66, 0x9a, 0xf9, 0x6a, 0x6a, 0x96, 0x29, 0xa6, 0x66, 0x9a, 0xf9,
0x9f, 0xa6, 0xa6, 0x26, 0x9f, 0xa9, 0xa6, 0x2a, 0x6e, 0xa9, 0xaa, 0x2a, 0x9e, 0xa9, 0xa6, 0x2a,
0x9e, 0xaa, 0xaa, 0x2a, 0x9e, 0xa9, 0xaa, 0x2a, 0x9e, 0xa6, 0xaa, 0x2a, 0x6e, 0xa6, 0xaa, 0x2a,
0x22, 0x22, 0x92, 0x22, 0xcc, 0x22, 0x9a, 0x22, 0xdc, 0x62, 0x9b, 0x22, 0xcd, 0x93, 0x9a, 0x27,
0x66, 0x66, 0x79, 0x24, 0x94, 0x99, 0x47, 0x24, 0x49, 0x79, 0x47, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0x2b, 0xdd, 0xc1, 0xba, 0xdb, 0x22, 0xc1, 0xba, 0xdd, 0xdd, 0xcc, 0xb6, 0xdd, 0xdc,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0x2d, 0xdc, 0xac, 0x29, 0x22, 0xcc, 0xad, 0x29, 0x2d, 0xcd, 0xac, 0x29, 0x2c, 0xcc, 0xad, 0x29,
0xdd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0x2b, 0x2d, 0xc1, 0xba, 0xdb, 0xd2, 0xc1, 0xba, 0xdd, 0xd2, 0xcc, 0xb6, 0xdd, 0xdd,
0xdd, 0xbd, 0xdb, 0xcd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0x2d, 0xdc, 0xac, 0x29, 0xc2, 0xcc, 0xad, 0x29, 0xc2, 0xcd, 0xac, 0x29, 0xdc, 0xcc, 0xad, 0x29,
0xdd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0x2b, 0xdd, 0xc1, 0xba, 0x2b, 0xdd, 0xc1, 0xba, 0xdd, 0x22, 0xcc, 0xb6, 0xdd, 0xdd,
0xdd, 0xbd, 0xdb, 0xcd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xcd, 0xdc, 0xac, 0x29, 0xdc, 0xcc, 0xad, 0x29, 0x22, 0xcd, 0xac, 0x29, 0xdc, 0xcc, 0xad, 0x29,
0xdd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0x2b, 0xdd, 0xc1, 0xba, 0x2b, 0xcd, 0xc1, 0xb6, 0x2d, 0xdd, 0xcc, 0xba, 0xdd, 0xdd,
0xdd, 0xbd, 0xdb, 0xcd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xbb, 0xd2, 0xc1, 0xba, 0xdb, 0xd2, 0xc1, 0xba, 0xdd, 0x2d, 0xcc, 0xb6, 0xdd, 0xdd,
0xdd, 0xbd, 0xdb, 0xcd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xcd, 0xdc, 0xac, 0x29, 0xdc, 0xcc, 0xad, 0x29, 0xc2, 0xcd, 0xac, 0x29, 0xdc, 0xcc, 0xad, 0x29,
0xdd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xbb, 0xd2, 0xc1, 0xba, 0xdb, 0x2d, 0xc1, 0xba, 0xdd, 0x2d, 0xcc, 0xb6, 0x2d, 0xc2,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xc2, 0xdc, 0xac, 0x29, 0xdd, 0xcc, 0xad, 0x29, 0xcc, 0xcd, 0xac, 0x29, 0xdd, 0xcc, 0xad, 0x29,
0xcd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0x2d, 0xdc, 0xac, 0x29, 0x2c, 0xcc, 0xad, 0x29, 0x22, 0xcd, 0xac, 0x29, 0xdc, 0xcc, 0xad, 0x29,
0xdd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xbb, 0x2d, 0xc1, 0xba, 0xdb, 0x2d, 0xc1, 0xba, 0xdd, 0x2d, 0xcc, 0xb6, 0xdd, 0xdd,
0xdd, 0xbd, 0xdb, 0xcd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xcd, 0xdc, 0xac, 0x29, 0xcd, 0xcc, 0xad, 0x29, 0xcd, 0xcd, 0xac, 0x29, 0xdc, 0xcc, 0xad, 0x29,
0xdd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0x2d, 0xdc, 0xac, 0x29, 0x2c, 0xcc, 0xad, 0x29, 0xc2, 0xcd, 0xac, 0x29, 0xdc, 0xcc, 0xad, 0x29,
0xdd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0x2b, 0xdd, 0xc1, 0xba, 0x2b, 0x22, 0xc1, 0xb6, 0x2d, 0xdd, 0xcc, 0xba, 0x2d, 0xdd,
0xdd, 0xbd, 0xdb, 0xcd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0x2d, 0xdc, 0xac, 0x29, 0xc2, 0xcc, 0xad, 0x29, 0xcd, 0xcd, 0xac, 0x29, 0xdc, 0xcc, 0xad, 0x29,
0xdd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xbb, 0xd2, 0xc1, 0xba, 0xdb, 0xd2, 0xc1, 0xba, 0xdd, 0xd2, 0xcc, 0xb6, 0xdd, 0x22,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xcd, 0xdc, 0xac, 0x29, 0xdc, 0xcc, 0xad, 0x29, 0xcd, 0xcd, 0xac, 0x29, 0xd2, 0xcc, 0xad, 0x29,
0xcd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xbb, 0xdd, 0xc1, 0xba, 0xdb, 0xdd, 0xc1, 0xba, 0xdd, 0xdc, 0xcc, 0xb6, 0xdd, 0x22,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xc2, 0xdc, 0xac, 0x29, 0xd2, 0xcc, 0xad, 0x29, 0xc2, 0xcd, 0xac, 0x29, 0xd2, 0xcc, 0xad, 0x29,
0xcd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xbb, 0x2d, 0xc1, 0xba, 0xdb, 0xdd, 0xc1, 0xba, 0xdd, 0xdc, 0xcc, 0xb6, 0xdd, 0xdd,
0xdd, 0xbd, 0xdb, 0xcd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x66, 0x66, 0x22, 0x22, 0x22, 0x22,
0xcd, 0xdc, 0xac, 0x27, 0xd2, 0xcc, 0xad, 0x27, 0xc2, 0xcd, 0xac, 0x27, 0xd2, 0xcc, 0xad, 0x27,
0xcd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x66, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc2, 0x93, 0x92, 0x62, 0xd2, 0x93, 0x26, 0xa2, 0xcc, 0x93, 0x69, 0xa6, 0xdc, 0x37, 0x66, 0xa6,
0x66, 0x36, 0x63, 0xa6, 0x94, 0x69, 0x99, 0x99, 0x49, 0x99, 0x77, 0x77, 0x22, 0x22, 0x22, 0x22,
0xb2, 0xd2, 0x92, 0x24, 0x2b, 0xdd, 0x92, 0x24, 0xdb, 0xdd, 0x9d, 0x24, 0xbb, 0xdd, 0x9b, 0x24,
0xaa, 0xab, 0x79, 0x24, 0x99, 0x99, 0x47, 0x24, 0x77, 0x77, 0x44, 0x29, 0x22, 0x22, 0x22, 0x22,
0xa6, 0xa6, 0x96, 0xf9, 0xa6, 0x6a, 0x9a, 0xf9, 0x6a, 0x6a, 0x6a, 0xf9, 0xa6, 0x6a, 0x9a, 0xf9,
0xaa, 0xa6, 0x96, 0xe9, 0xaa, 0x6a, 0x6a, 0xf9, 0xaa, 0xaa, 0x6a, 0xe9, 0xaa, 0x6a, 0x9a, 0xe9,
0x9e, 0xaa, 0xaa, 0x2a, 0xae, 0xa9, 0xaa, 0x2b, 0x9e, 0xaa, 0xba, 0x2b, 0xae, 0xaa, 0xba, 0x2a,
0x6e, 0xb9, 0xba, 0x2b, 0xae, 0xaa, 0xba, 0x2b, 0x9e, 0xb6, 0xba, 0x2b, 0xae, 0xaa, 0xba, 0x2b,
0x49, 0xc1, 0x6a, 0xa6, 0x14, 0xd1, 0xdd, 0xdd, 0x11, 0x3c, 0x77, 0x37, 0xcc, 0x77, 0x77, 0x33,
0xcc, 0x77, 0x33, 0x33, 0x2c, 0x72, 0x23, 0x33, 0xc2, 0x37, 0x92, 0x92, 0xd2, 0x33, 0x22, 0x62,
0xdb, 0xad, 0x49, 0x29, 0xdd, 0xbd, 0x76, 0x24, 0x37, 0x33, 0x96, 0x27, 0x33, 0x33, 0x93, 0x27,
0x33, 0x63, 0x96, 0x27, 0x22, 0x66, 0x2a, 0x22, 0x62, 0xb2, 0x92, 0x27, 0x22, 0xbb, 0x2b, 0x22,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0xba, 0xdb, 0xad, 0x29,
0xbb, 0xdd, 0xad, 0x29, 0xdd, 0xdd, 0xad, 0x29, 0xd2, 0xdc, 0xac, 0x29, 0x2d, 0xcd, 0xad, 0x29,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0xaa,
0xc1, 0x69, 0xa6, 0xaa, 0xc1, 0xa9, 0xaa, 0xbb, 0xc1, 0x66, 0xba, 0x22, 0xc1, 0xaa, 0x2a, 0xdd,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0xba, 0xdb, 0xad, 0x29,
0xbb, 0xdd, 0xad, 0x29, 0xdd, 0xdd, 0xad, 0x29, 0xd2, 0xdc, 0xac, 0x29, 0xdd, 0xcd, 0xad, 0x29,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0x2a, 0xdb, 0xad, 0x29,
0x2b, 0xdd, 0xad, 0x29, 0x2d, 0xdd, 0xad, 0x29, 0x22, 0xdc, 0xac, 0x29, 0x2d, 0xcd, 0xad, 0x29,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0x2a,
0xc1, 0x69, 0xa6, 0xb2, 0xc1, 0xa9, 0xaa, 0xb2, 0xc1, 0x66, 0x2a, 0x22, 0xc1, 0xaa, 0xbb, 0xd2,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0xb2, 0xdb, 0xad, 0x29,
0xbb, 0xdd, 0xad, 0x29, 0xdd, 0xdd, 0xad, 0x29, 0xd2, 0xdc, 0xac, 0x29, 0xdd, 0xcd, 0xad, 0x29,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0xba, 0xdb, 0xad, 0x29,
0xbb, 0xdd, 0xad, 0x29, 0xdd, 0xdd, 0xad, 0x29, 0x22, 0xdc, 0xac, 0x29, 0x2d, 0xcd, 0xad, 0x29,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x26, 0xaa,
0xc1, 0x69, 0x26, 0xaa, 0xc1, 0xa9, 0x2a, 0xbb, 0xc1, 0x66, 0x2a, 0x22, 0xc1, 0xaa, 0x2b, 0xdd,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0xaa,
0xc1, 0x69, 0xa6, 0xaa, 0xc1, 0xa9, 0xaa, 0xbb, 0xc1, 0x66, 0xba, 0xdd, 0xc1, 0xaa, 0xbb, 0xdd,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0xba, 0xdb, 0xad, 0x29,
0xb2, 0xdd, 0xad, 0x29, 0xdd, 0xdd, 0xad, 0x29, 0xd2, 0xdc, 0xac, 0x29, 0xd2, 0xcd, 0xad, 0x29,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x26, 0xaa,
0xc1, 0x69, 0x26, 0xaa, 0xc1, 0xa9, 0x2a, 0xbb, 0xc1, 0x66, 0x2a, 0xdd, 0xc1, 0xaa, 0x2b, 0x2d,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0xa2,
0xc1, 0x69, 0xa6, 0xb2, 0xc1, 0xa9, 0xaa, 0xb2, 0xc1, 0x66, 0xba, 0xd2, 0xc1, 0xaa, 0xbb, 0xd2,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0xaa,
0xc1, 0x69, 0xa6, 0xaa, 0xc1, 0xa9, 0xaa, 0xbb, 0xc1, 0x66, 0xba, 0x2d, 0xc1, 0xaa, 0xbb, 0xdd,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0xaa,
0xc1, 0x69, 0xa6, 0x2a, 0xc1, 0xa9, 0xaa, 0xb2, 0xc1, 0x66, 0xba, 0xdd, 0xc1, 0xaa, 0xbb, 0xdd,
0x49, 0xc1, 0xdd, 0xdd, 0x14, 0xd1, 0xdd, 0xdd, 0x11, 0x3c, 0x77, 0x77, 0xcc, 0x77, 0x77, 0x33,
0xcc, 0x77, 0x37, 0x33, 0xdc, 0x77, 0x37, 0x33, 0xdc, 0x77, 0x33, 0x39, 0xcc, 0x37, 0x33, 0x66,
0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0x73, 0x37, 0x77, 0x73, 0x37, 0x73, 0x33, 0x37,
0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x36, 0x96, 0x62, 0x63, 0x63, 0x26, 0x92, 0x36,
0xdd, 0xdd, 0x6a, 0xa6, 0xdd, 0xdd, 0xdd, 0xdd, 0x37, 0x77, 0x73, 0x37, 0x23, 0x22, 0x37, 0x33,
0x23, 0x22, 0x33, 0x33, 0x23, 0x22, 0x33, 0x33, 0x29, 0x22, 0x36, 0x36, 0x26, 0x22, 0x69, 0x63,
0xdd, 0x6d, 0x49, 0x29, 0xdd, 0xbd, 0x76, 0x24, 0x37, 0x33, 0x96, 0x27, 0x33, 0x33, 0x93, 0x24,
0x33, 0x63, 0x96, 0x24, 0x22, 0x66, 0x92, 0x22, 0x62, 0xb2, 0x22, 0x22, 0xa2, 0xb2, 0x22, 0x22,
0xaa, 0xaa, 0x9a, 0xe6, 0xaa, 0xaa, 0x6a, 0xe9, 0xaa, 0xaa, 0xaa, 0xe9, 0xaa, 0xaa, 0x9a, 0xe9,
0xaa, 0xaa, 0xaa, 0xe9, 0xaa, 0xaa, 0x6a, 0xe6, 0xba, 0xaa, 0x9a, 0xe6, 0xba, 0xaa, 0xaa, 0xe9,
0x6e, 0xba, 0xba, 0x2b, 0xae, 0xaa, 0xbb, 0x2b, 0x9e, 0xba, 0xbb, 0x2b, 0xaf, 0xaa, 0xbb, 0x2b,
0xaf, 0xba, 0xbb, 0x2b, 0xaf, 0xba, 0xbb, 0x2b, 0xa2, 0xba, 0xbb, 0x2b, 0x92, 0xba, 0xbb, 0x2b,
0xc2, 0x93, 0x92, 0x62, 0x2c, 0x92, 0x62, 0xa2, 0xdc, 0x93, 0x66, 0xa6, 0xcd, 0x33, 0x66, 0xa6,
0x66, 0x36, 0x63, 0xa6, 0x94, 0x69, 0x99, 0x99, 0x49, 0x99, 0x77, 0x77, 0x22, 0x22, 0x22, 0x22,
0xb2, 0xdd, 0x9d, 0x22, 0xb2, 0xdd, 0x22, 0x27, 0xdb, 0xdd, 0x9d, 0x27, 0xbb, 0xdd, 0x9b, 0x27,
0xaa, 0xab, 0x79, 0x24, 0x99, 0x99, 0x47, 0x24, 0x77, 0x77, 0x47, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xbb, 0x22, 0xc1, 0xba, 0x2b, 0xdd, 0xc1, 0xb6, 0x2d, 0xdd, 0xcc, 0xba, 0xdd, 0x22,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0x22, 0xdc, 0xac, 0x29, 0x2d, 0xcc, 0xad, 0x29, 0x2c, 0xcd, 0xac, 0x29, 0x22, 0xcc, 0xad, 0x29,
0xcd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xbb, 0x22, 0xc1, 0xba, 0xdb, 0xdd, 0xc1, 0xba, 0xdd, 0xdd, 0xcc, 0xb6, 0x2d, 0x22,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xcd, 0xdc, 0xac, 0x29, 0xd2, 0xcc, 0xad, 0x29, 0xc2, 0xcd, 0xac, 0x29, 0xdc, 0xcc, 0xad, 0x29,
0xcd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0x2b, 0xdd, 0xc1, 0xba, 0x2b, 0xcd, 0xc1, 0xb6, 0x2d, 0xdd, 0xcc, 0xba, 0xdd, 0x22,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0x2d, 0xdc, 0xac, 0x29, 0x2d, 0xcc, 0xad, 0x29, 0x2c, 0xcd, 0xac, 0x29, 0x22, 0xcc, 0xad, 0x29,
0xcd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xbb, 0xd2, 0xc1, 0xba, 0xdb, 0xd2, 0xc1, 0xba, 0xdd, 0xd2, 0xcc, 0xb6, 0xdd, 0xd2,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xcd, 0xdc, 0xac, 0x29, 0xdc, 0xcc, 0xad, 0x29, 0xcd, 0xcd, 0xac, 0x29, 0xdc, 0xcc, 0xad, 0x29,
0xdc, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0x2b, 0xdd, 0xc1, 0xba, 0x2b, 0xcd, 0xc1, 0xba, 0xdd, 0x22, 0xcc, 0xb6, 0xdd, 0xdd,
0xdd, 0xbd, 0x2b, 0x22, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0x2d, 0xdc, 0xac, 0x29, 0x2d, 0xcc, 0xad, 0x29, 0x22, 0xcd, 0xac, 0x29, 0x2d, 0xcc, 0xad, 0x29,
0xd2, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0x2b, 0xdd, 0xc1, 0xba, 0x2b, 0xcd, 0xc1, 0xb6, 0x2d, 0xdd, 0xcc, 0xba, 0x2d, 0xcd,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0x2d, 0xdc, 0xac, 0x29, 0x2d, 0xcc, 0xad, 0x29, 0x2c, 0xcd, 0xac, 0x29, 0x2d, 0xcc, 0xad, 0x29,
0xcd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xbb, 0xdd, 0xc1, 0xba, 0xdb, 0xdd, 0xc1, 0xba, 0xdd, 0xdc, 0xcc, 0xb6, 0xdd, 0xdd,
0xdd, 0xbd, 0xdb, 0x22, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0x2b, 0xd2, 0xc1, 0xba, 0x2b, 0x2d, 0xc1, 0xb6, 0x2d, 0xdd, 0xcc, 0xba, 0x2d, 0xcd,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xcd, 0xdc, 0xac, 0x29, 0xcd, 0xcc, 0xad, 0x29, 0xc2, 0xcd, 0xac, 0x29, 0xd2, 0xcc, 0xad, 0x29,
0xcd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xbb, 0xd2, 0xc1, 0xba, 0xdb, 0xd2, 0xc1, 0xba, 0xdd, 0xd2, 0xcc, 0xb6, 0xdd, 0x2d,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xcd, 0xdc, 0xac, 0x29, 0xdc, 0xcc, 0xad, 0x29, 0xcd, 0xcd, 0xac, 0x29, 0xdc, 0xcc, 0xad, 0x29,
0xcd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xbb, 0xdd, 0xc1, 0xba, 0xdb, 0xcd, 0xc1, 0xba, 0xdd, 0x2d, 0xcc, 0xb6, 0xdd, 0xd2,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xbb, 0xdd, 0xc1, 0xba, 0xdb, 0xcd, 0xc1, 0xba, 0xdd, 0xdd, 0xcc, 0xb6, 0xdd, 0xdc,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xdc, 0x37, 0x99, 0x66, 0xcc, 0x77, 0x63, 0x66, 0xdc, 0x37, 0x33, 0xa9, 0xdc, 0x33, 0x33, 0x93,
0x66, 0x36, 0x33, 0x63, 0x94, 0x69, 0x99, 0x99, 0x49, 0x99, 0x77, 0x77, 0x22, 0x22, 0x22, 0x22,
0x66, 0x22, 0x22, 0x22, 0x26, 0x22, 0x22, 0x22, 0xaa, 0x22, 0x22, 0x22, 0x66, 0x26, 0xa2, 0xaa,
0x63, 0x99, 0x92, 0x36, 0x99, 0x99, 0x99, 0x99, 0x77, 0x77, 0x77, 0x77, 0x22, 0x22, 0x22, 0x22,
0x22, 0x22, 0x66, 0x66, 0x22, 0x22, 0xa6, 0xa6, 0x22, 0xa2, 0xaa, 0xaa, 0xaa, 0xaa, 0x66, 0x66,
0x96, 0x39, 0x96, 0x69, 0x99, 0x99, 0x99, 0x99, 0x77, 0x77, 0x77, 0x77, 0x22, 0x22, 0x22, 0x22,
0xb2, 0xd2, 0x92, 0x22, 0x22, 0xdd, 0x92, 0x22, 0xdb, 0xdd, 0x9d, 0x24, 0xbb, 0xdd, 0x9b, 0x24,
0xaa, 0xab, 0x79, 0x24, 0x99, 0x99, 0x47, 0x24, 0x77, 0x77, 0x44, 0x29, 0x22, 0x22, 0x22, 0x22,
0xba, 0xab, 0x6a, 0xea, 0xaa, 0xab, 0x6a, 0xe9, 0xba, 0xab, 0xaa, 0xfa, 0xba, 0xab, 0xaa, 0xf6,
0xb6, 0xab, 0xaa, 0xf9, 0xba, 0xbb, 0xaa, 0xfa, 0xb6, 0xbb, 0xaa, 0xf9, 0xb6, 0xab, 0xaa, 0x2a,
0xa2, 0xba, 0xbb, 0x2b, 0x92, 0xba, 0xbb, 0x2a, 0x92, 0xba, 0xbb, 0x2a, 0x92, 0xba, 0xbb, 0x26,
0x92, 0xb6, 0xbb, 0x26, 0x92, 0xb9, 0xab, 0x26, 0x92, 0xa9, 0x6a, 0x26, 0x92, 0x69, 0x66, 0x26,
0x49, 0xc1, 0xdd, 0xdd, 0x14, 0xd1, 0xdd, 0xdd, 0x11, 0x3c, 0x77, 0x77, 0xcc, 0x77, 0x77, 0x33,
0xcc, 0x77, 0x37, 0x33, 0xdc, 0x77, 0x22, 0x23, 0xdc, 0x27, 0x33, 0x29, 0xcc, 0x23, 0x22, 0x29,
0xdd, 0xdd, 0x6a, 0xa6, 0xdd, 0xdd, 0xdd, 0xdd, 0x37, 0x77, 0x73, 0x37, 0x73, 0x33, 0x37, 0x33,
0x33, 0x33, 0x33, 0x33, 0x23, 0x23, 0x23, 0x22, 0x29, 0x29, 0x29, 0x39, 0x22, 0x26, 0x26, 0x22,
0xdb, 0xad, 0x49, 0x29, 0xdd, 0xbd, 0x76, 0x24, 0x37, 0x33, 0x96, 0x27, 0x33, 0x33, 0x93, 0x27,
0x33, 0x63, 0x96, 0x27, 0x23, 0x22, 0x96, 0x27, 0x66, 0xb2, 0x9b, 0x27, 0xa6, 0xb2, 0x9b, 0x27,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0xba, 0xdb, 0xad, 0x29,
0xbb, 0xdd, 0xad, 0x29, 0xdd, 0xdd, 0xad, 0x29, 0x22, 0xdc, 0xac, 0x29, 0xd2, 0xcd, 0xad, 0x29,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0xaa,
0xc1, 0x69, 0xa6, 0xaa, 0xc1, 0xa9, 0xaa, 0xbb, 0xc1, 0x66, 0x2a, 0xdd, 0xc1, 0xaa, 0xbb, 0xd2,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0xba, 0xdb, 0xad, 0x29,
0xbb, 0xdd, 0xad, 0x29, 0xdd, 0xdd, 0xad, 0x29, 0x2d, 0xdc, 0xac, 0x29, 0xd2, 0xcd, 0xad, 0x29,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0xba, 0xdb, 0xad, 0x29,
0xbb, 0xdd, 0xad, 0x29, 0xdd, 0xdd, 0xad, 0x29, 0x22, 0xdc, 0xac, 0x29, 0xdd, 0xcd, 0xad, 0x29,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0xaa,
0xc1, 0x69, 0xa6, 0xaa, 0xc1, 0xa9, 0xaa, 0xbb, 0xc1, 0x66, 0x2a, 0xdd, 0xc1, 0xaa, 0x2a, 0xdd,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0xba, 0xdb, 0xad, 0x29,
0xbb, 0xdd, 0xad, 0x29, 0xdd, 0xdd, 0xad, 0x29, 0x2d, 0xdc, 0xac, 0x29, 0x2d, 0xcd, 0xad, 0x29,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0xaa,
0xc1, 0x69, 0xa6, 0xaa, 0xc1, 0xa9, 0xaa, 0xbb, 0xc1, 0x66, 0x2a, 0x22, 0xc1, 0xaa, 0x2a, 0xdd,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0xaa,
0xc1, 0x69, 0xa6, 0xaa, 0xc1, 0xa9, 0xaa, 0xbb, 0xc1, 0x66, 0x22, 0x22, 0xc1, 0xaa, 0xb2, 0x2d,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0xba, 0xdb, 0xad, 0x29,
0xbb, 0xdd, 0xad, 0x29, 0xdd, 0xdd, 0xad, 0x29, 0x22, 0xdc, 0xac, 0x29, 0xdd, 0xc2, 0xad, 0x29,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0xaa,
0xc1, 0x69, 0xa6, 0xaa, 0xc1, 0xa9, 0xaa, 0xbb, 0xc1, 0x66, 0xba, 0x2d, 0xc1, 0xaa, 0xbb, 0x2d,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0xb2, 0xdb, 0xad, 0x29,
0xb2, 0xdd, 0xad, 0x29, 0xd2, 0xdd, 0xad, 0x29, 0xdd, 0xdc, 0xac, 0x29, 0xdd, 0xcd, 0xad, 0x29,
0x49, 0xd1, 0x6a, 0xa6, 0x14, 0xc1, 0xdd, 0xdd, 0x11, 0x7d, 0x77, 0x77, 0xc1, 0x73, 0x77, 0x33,
0xcc, 0x77, 0x37, 0x33, 0xdc, 0x77, 0x22, 0x23, 0xdc, 0x27, 0x33, 0x29, 0xcc, 0x27, 0x22, 0x29,
0xdb, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0x37, 0x77, 0x73, 0x37, 0x73, 0x33, 0x37, 0x33,
0x33, 0x33, 0x33, 0x33, 0x23, 0x23, 0x23, 0x22, 0x29, 0x29, 0x29, 0x39, 0x22, 0x26, 0x26, 0x22,
0xdd, 0xad, 0x49, 0x29, 0xdd, 0xbd, 0x76, 0x24, 0x37, 0x33, 0x96, 0x27, 0x33, 0x33, 0x93, 0x27,
0x33, 0x63, 0x96, 0x27, 0x23, 0x22, 0x96, 0x27, 0x66, 0xb2, 0x9b, 0x27, 0xa6, 0xb2, 0x9b, 0x27,
0x49, 0xc1, 0xdd, 0xdd, 0x14, 0xd1, 0xdd, 0xdd, 0x11, 0x3c, 0x77, 0x37, 0xc1, 0x77, 0x77, 0x23,
0xcc, 0x77, 0x33, 0x22, 0xdc, 0x77, 0x23, 0x22, 0xcc, 0x37, 0x22, 0x22, 0xdc, 0x33, 0x99, 0x22,
0xdd, 0x6d, 0x49, 0x29, 0xdd, 0xbd, 0x76, 0x24, 0x37, 0x33, 0x96, 0x27, 0x33, 0x33, 0x93, 0x24,
0x32, 0x63, 0x96, 0x24, 0x22, 0x66, 0x9a, 0x24, 0x22, 0xb2, 0x9b, 0x24, 0xa2, 0xbb, 0x9b, 0x24,
0x49, 0xc1, 0xdd, 0xdd, 0x14, 0xd1, 0xdd, 0xdd, 0x11, 0x3c, 0x77, 0x37, 0xc1, 0x77, 0x77, 0x33,
0xcc, 0x77, 0x33, 0x33, 0xdc, 0x27, 0x32, 0x32, 0xcc, 0x27, 0x93, 0x22, 0xdc, 0x23, 0x92, 0x22,
0xdd, 0x6d, 0x49, 0x29, 0xdd, 0xbd, 0x76, 0x24, 0x37, 0x33, 0x96, 0x27, 0x33, 0x33, 0x93, 0x24,
0x33, 0x63, 0x96, 0x24, 0x62, 0x22, 0x9a, 0x24, 0x62, 0xb2, 0x92, 0x24, 0xa2, 0xb2, 0x92, 0x24,
0xb6, 0xbb, 0xab, 0x29, 0xa6, 0xbb, 0xaa, 0x29, 0xa6, 0xbb, 0xab, 0x29, 0x66, 0xbb, 0xaa, 0x29,
0x66, 0xbb, 0xab, 0x29, 0x66, 0xba, 0x9b, 0x29, 0x66, 0xba, 0x9b, 0x29, 0x66, 0xa6, 0x9a, 0x29,
0x92, 0x69, 0x66, 0x26, 0x92, 0x99, 0x66, 0x26, 0x92, 0x69, 0x66, 0x26, 0x92, 0x99, 0x66, 0x26,
0x92, 0x69, 0x66, 0x26, 0x92, 0x69, 0x66, 0x26, 0x92, 0x99, 0x66, 0x26, 0x92, 0x69, 0x66, 0x26,
0xdc, 0x93, 0x29, 0x26, 0xcc, 0x27, 0x62, 0x26, 0xdc, 0x37, 0x99, 0xa6, 0xcd, 0x33, 0x33, 0x66,
0x66, 0x36, 0x33, 0x93, 0x94, 0x69, 0x99, 0x99, 0x49, 0x99, 0x77, 0x77, 0x22, 0x22, 0x22, 0x22,
0x26, 0x26, 0x26, 0x66, 0x2a, 0x26, 0x26, 0xa6, 0xaa, 0xaa, 0xaa, 0xaa, 0xa6, 0xaa, 0xaa, 0x66,
0x36, 0x36, 0x36, 0x96, 0x99, 0x99, 0x99, 0x99, 0x77, 0x77, 0x77, 0x77, 0x22, 0x22, 0x22, 0x22,
0xb6, 0xd2, 0x9b, 0x27, 0xbb, 0xd2, 0x9d, 0x27, 0xbb, 0xbd, 0x9b, 0x27, 0xa6, 0xbb, 0x9b, 0x27,
0x66, 0xba, 0x79, 0x24, 0x99, 0x99, 0x47, 0x24, 0x77, 0x77, 0x47, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xbb, 0x2d, 0xc1, 0xba, 0xdb, 0xd2, 0xc1, 0xba, 0x2d, 0xcd, 0xcc, 0xb6, 0x2d, 0x22,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xcd, 0xdc, 0xac, 0x29, 0xcd, 0xcc, 0xad, 0x29, 0xcd, 0xcd, 0xac, 0x29, 0x22, 0xcc, 0xad, 0x29,
0xcd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xbb, 0x2d, 0xc1, 0xba, 0xdb, 0x2d, 0xc1, 0xba, 0xdd, 0xd2, 0xcc, 0xb6, 0x2d, 0xdd,
0xdd, 0xbd, 0xdb, 0xcd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xcd, 0xdc, 0xac, 0x29, 0xcd, 0xcc, 0xad, 0x29, 0xc2, 0xcd, 0xac, 0x29, 0x2c, 0xcc, 0xad, 0x29,
0xdd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xbb, 0xd2, 0xc1, 0xba, 0xdb, 0xd2, 0xc1, 0xba, 0xdd, 0x2d, 0xcc, 0xb6, 0xdd, 0x2d,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x66, 0x66, 0x22, 0x22, 0x22, 0x22,
0xd2, 0xcc, 0xac, 0x29, 0xc2, 0xcd, 0xad, 0x29, 0xdc, 0xcc, 0xac, 0x29, 0xcd, 0xdc, 0xad, 0x29,
0xdc, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x66, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0x2b, 0xdd, 0xc1, 0xba, 0x2b, 0xcd, 0xc1, 0xb6, 0x2d, 0xdd, 0xcc, 0xba, 0x2d, 0x22,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x66, 0x66, 0x22, 0x22, 0x22, 0x22,
0x2d, 0xdc, 0xac, 0x29, 0x2d, 0xcc, 0xad, 0x29, 0x2c, 0xcd, 0xac, 0x29, 0xd2, 0xcc, 0xad, 0x29,
0xcd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x66, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0x2b, 0xdd, 0xc1, 0xba, 0x2b, 0xcd, 0xc1, 0xb6, 0x2d, 0xdd, 0xcc, 0xba, 0x2d, 0xcd,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x66, 0x66, 0x22, 0x22, 0x22, 0x22,
0x2d, 0xdc, 0xac, 0x29, 0x2d, 0xcc, 0xad, 0x29, 0x2c, 0xcd, 0xac, 0x29, 0x2d, 0xcc, 0xad, 0x29,
0xcd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x66, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xd2, 0x2d, 0xc1, 0xba, 0xd2, 0x2d, 0xc1, 0xb6, 0xd2, 0x2d, 0xcc, 0xba, 0xd2, 0x2d,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x66, 0x66, 0x22, 0x22, 0x22, 0x22,
0xcd, 0xc2, 0xac, 0x29, 0xcd, 0xc2, 0xad, 0x29, 0xcd, 0xc2, 0xac, 0x29, 0xdc, 0xc2, 0xad, 0x29,
0xcd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x66, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xbb, 0xdd, 0xc1, 0xba, 0xdb, 0xcd, 0xc1, 0xba, 0xdd, 0xdd, 0xcc, 0xb6, 0xdd, 0x2d,
0xdd, 0xbd, 0xdb, 0xd2, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xbb, 0xdd, 0xc1, 0xba, 0xdb, 0xcd, 0xc1, 0xba, 0xdd, 0xdd, 0xcc, 0xb6, 0xdd, 0x2d,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xbb, 0x2d, 0xc1, 0xba, 0xdb, 0xd2, 0xc1, 0xba, 0xdd, 0xd2, 0xcc, 0xb6, 0xdd, 0xd2,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xdc, 0x37, 0x29, 0x26, 0xcc, 0x27, 0x62, 0x26, 0xdc, 0x37, 0x33, 0xa6, 0xcd, 0x33, 0x33, 0x69,
0x66, 0x36, 0x33, 0x63, 0x94, 0x69, 0x99, 0x99, 0x49, 0x79, 0x77, 0x77, 0x22, 0x22, 0x22, 0x22,
0x26, 0x26, 0x26, 0x66, 0x2a, 0x26, 0x26, 0xa6, 0xaa, 0xaa, 0xaa, 0xaa, 0x66, 0xaa, 0xaa, 0x6a,
0x63, 0x39, 0x36, 0x69, 0x99, 0x99, 0x99, 0x99, 0x77, 0x77, 0x77, 0x77, 0x22, 0x22, 0x22, 0x22,
0xb6, 0xd2, 0x6d, 0x27, 0xbb, 0xd2, 0x9d, 0x27, 0xdb, 0xdd, 0x9b, 0x27, 0xaa, 0xbb, 0x9b, 0x27,
0x66, 0xba, 0x79, 0x24, 0x99, 0x99, 0x47, 0x24, 0x77, 0x77, 0x44, 0x29, 0x22, 0x22, 0x22, 0x22,
0xcc, 0x93, 0x99, 0x22, 0xdc, 0x93, 0x66, 0x22, 0xcc, 0x93, 0x69, 0x22, 0xdc, 0x37, 0x66, 0xa6,
0x66, 0x36, 0x63, 0xa6, 0x94, 0x69, 0x99, 0x99, 0x49, 0x99, 0x77, 0x77, 0x22, 0x22, 0x22, 0x22,
0xb2, 0xdd, 0x9d, 0x24, 0xb2, 0xdd, 0x9d, 0x24, 0xd2, 0xdd, 0x9d, 0x24, 0xbb, 0xdd, 0x9b, 0x24,
0xba, 0xab, 0x79, 0x24, 0x99, 0x99, 0x47, 0x24, 0x77, 0x77, 0x44, 0x29, 0x22, 0x22, 0x22, 0x22,
0xcc, 0x23, 0x99, 0x62, 0xdc, 0x29, 0x62, 0xa2, 0xcc, 0x93, 0x66, 0xa6, 0xdc, 0x37, 0x66, 0xa6,
0x66, 0x36, 0x63, 0xa6, 0x94, 0x69, 0x99, 0x99, 0x49, 0x99, 0x77, 0x77, 0x22, 0x22, 0x22, 0x22,
0xb2, 0xd2, 0x92, 0x24, 0xb2, 0x22, 0x9d, 0x24, 0xdb, 0xdd, 0x9d, 0x24, 0xbb, 0xdd, 0x9b, 0x24,
0xba, 0xba, 0x79, 0x24, 0x99, 0x99, 0x47, 0x24, 0x77, 0x77, 0x44, 0x29, 0x22, 0x22, 0x22, 0x22,
0x66, 0x66, 0x99, 0x29, 0x66, 0x66, 0x96, 0x29, 0x66, 0x66, 0x96, 0x29, 0x66, 0x66, 0x99, 0x29,
0x66, 0x66, 0x96, 0x29, 0x66, 0x66, 0x96, 0x29, 0x66, 0x66, 0x96, 0x29, 0x66, 0x66, 0x99, 0x29,
0x49, 0xc1, 0xdd, 0xdd, 0x14, 0xd1, 0xdd, 0xdd, 0x11, 0x3c, 0x77, 0x37, 0xcc, 0x77, 0x77, 0x33,
0xcc, 0x77, 0x33, 0x33, 0x2c, 0x72, 0x22, 0x32, 0xc2, 0x37, 0x23, 0x99, 0xd2, 0x33, 0x29, 0x66,
0xdd, 0xad, 0x49, 0x29, 0xdd, 0xbd, 0x76, 0x24, 0x37, 0x33, 0x96, 0x27, 0x33, 0x33, 0x93, 0x27,
0x33, 0x63, 0x96, 0x27, 0x22, 0x66, 0x92, 0x27, 0x62, 0xb2, 0x92, 0x27, 0x22, 0xbb, 0x92, 0x27,
0x49, 0xd1, 0x6a, 0xa6, 0x14, 0xc1, 0xdd, 0xdd, 0x11, 0x7d, 0x77, 0x37, 0xc1, 0x73, 0x77, 0x33,
0xcc, 0x77, 0x33, 0x33, 0xdc, 0x77, 0x22, 0x33, 0xcc, 0x37, 0x92, 0x92, 0xdc, 0x33, 0x92, 0x62,
0xdb, 0xad, 0x49, 0x29, 0xdd, 0xbd, 0x76, 0x24, 0x37, 0x33, 0x96, 0x27, 0x33, 0x33, 0x93, 0x27,
0x33, 0x63, 0x96, 0x27, 0x29, 0x62, 0x9a, 0x27, 0x62, 0xba, 0x9b, 0x27, 0x22, 0xb2, 0x9b, 0x27,
0x49, 0xd1, 0x6a, 0xa6, 0x14, 0xc1, 0xdd, 0xdd, 0x11, 0x7d, 0x77, 0x37, 0xc1, 0x73, 0x77, 0x33,
0xcc, 0x77, 0x33, 0x33, 0xdc, 0x27, 0x33, 0x32, 0xcc, 0x32, 0x32, 0x32, 0xdc, 0x22, 0x92, 0x62,
0xdb, 0xad, 0x49, 0x29, 0xdd, 0xbd, 0x76, 0x24, 0x37, 0x33, 0x96, 0x27, 0x33, 0x33, 0x93, 0x27,
0x33, 0x63, 0x96, 0x27, 0x69, 0x22, 0x92, 0x27, 0x66, 0x2a, 0x9b, 0x27, 0xa6, 0x2b, 0x9b, 0x27,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0xa2,
0xc1, 0x69, 0xa6, 0x2a, 0xc1, 0xa9, 0xaa, 0xbb, 0xc1, 0x66, 0xba, 0xdd, 0xc1, 0xaa, 0xbb, 0xdd,
0x49, 0xd1, 0x6a, 0xa6, 0x14, 0xc1, 0xdd, 0xdd, 0x11, 0x7d, 0x77, 0x77, 0xc1, 0x73, 0x77, 0x33,
0xcc, 0x77, 0x37, 0x33, 0xdc, 0x77, 0x37, 0x33, 0xdc, 0x77, 0x33, 0x33, 0xcc, 0x37, 0x33, 0x66,
0xdb, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0x73, 0x37, 0x77, 0x73, 0x37, 0x73, 0x33, 0x37,
0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x36, 0x36, 0x36, 0x36, 0x63, 0x66, 0x63, 0x66,
0xdd, 0xdd, 0x6a, 0xa6, 0xdd, 0xdd, 0xdd, 0xdd, 0x37, 0x77, 0x73, 0x37, 0x73, 0x33, 0x37, 0x73,
0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x36, 0x36, 0x36, 0x36, 0x63, 0x66, 0x63, 0x66,
0xdb, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0x77, 0x73, 0x37, 0x77, 0x33, 0x37, 0x73, 0x33,
0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x23, 0x36, 0x36, 0x96, 0x92, 0x63, 0x66, 0x63, 0x22,
0xdd, 0xdd, 0x6a, 0xa6, 0xdd, 0xdd, 0xdd, 0xdd, 0x73, 0x37, 0x77, 0x73, 0x37, 0x73, 0x33, 0x37,
0x33, 0x33, 0x33, 0x33, 0x32, 0x22, 0x33, 0x23, 0x99, 0x92, 0x92, 0x92, 0x62, 0x22, 0x69, 0x22,
0xdb, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0x37, 0x77, 0x73, 0x37, 0x73, 0x33, 0x37, 0x73,
0x33, 0x33, 0x33, 0x33, 0x33, 0x23, 0x32, 0x22, 0x92, 0x92, 0x99, 0x92, 0x62, 0x62, 0x66, 0x22,
0xdd, 0xdd, 0x6a, 0xa6, 0xdd, 0xdd, 0xdd, 0xdd, 0x77, 0x73, 0x37, 0x77, 0x33, 0x37, 0x73, 0x33,
0x33, 0x33, 0x33, 0x33, 0x32, 0x33, 0x33, 0x33, 0x39, 0x36, 0x36, 0x36, 0x62, 0x63, 0x66, 0x63,
0xdb, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0x73, 0x37, 0x77, 0x73, 0x37, 0x73, 0x33, 0x37,
0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x36, 0x36, 0x36, 0x36, 0x66, 0x63, 0x66, 0x63,
0xdd, 0xdd, 0x6a, 0xa6, 0xdd, 0xdd, 0xdd, 0xdd, 0x37, 0x77, 0x73, 0x37, 0x73, 0x33, 0x37, 0x33,
0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x36, 0x36, 0x36, 0x36, 0x66, 0x63, 0x66, 0x63,
0xdb, 0xad, 0x49, 0x29, 0xdd, 0xbd, 0x76, 0x24, 0x37, 0x33, 0x96, 0x27, 0x33, 0x33, 0x93, 0x27,
0x33, 0x63, 0x96, 0x27, 0x33, 0x66, 0x96, 0x27, 0x66, 0xaa, 0x9a, 0x27, 0xa6, 0xbb, 0x9b, 0x27,
0x49, 0xc1, 0xdd, 0xdd, 0x14, 0xd1, 0xdd, 0xdd, 0x11, 0x7c, 0x77, 0x37, 0xc1, 0x77, 0x77, 0x33,
0xcc, 0x77, 0x33, 0x33, 0xdc, 0x22, 0x32, 0x32, 0xcc, 0x27, 0x93, 0x22, 0xdc, 0x23, 0x99, 0x22,
0xdd, 0x6d, 0x49, 0x29, 0xdd, 0xbd, 0x76, 0x24, 0x37, 0x33, 0x96, 0x27, 0x33, 0x33, 0x93, 0x24,
0x33, 0x63, 0x96, 0x24, 0x62, 0x26, 0x92, 0x24, 0x62, 0xb2, 0x9b, 0x24, 0xa2, 0x22, 0x92, 0x24,
0x49, 0xc1, 0xdd, 0xdd, 0x14, 0xd1, 0xdd, 0xdd, 0x11, 0x7c, 0x77, 0x37, 0xc1, 0x77, 0x77, 0x33,
0xcc, 0x77, 0x33, 0x33, 0xdc, 0x27, 0x32, 0x23, 0xcc, 0x27, 0x23, 0x29, 0xdc, 0x23, 0x29, 0x26,
0xdd, 0x6d, 0x49, 0x29, 0xdd, 0xbd, 0x76, 0x24, 0x37, 0x33, 0x96, 0x27, 0x33, 0x33, 0x93, 0x24,
0x33, 0x63, 0x96, 0x24, 0x62, 0x62, 0x9a, 0x24, 0x69, 0xb2, 0x9b, 0x24, 0xa2, 0xb2, 0x9b, 0x24,
0x49, 0xd1, 0x6a, 0xa6, 0x14, 0xc1, 0xdd, 0xdd, 0x11, 0x7d, 0x77, 0x37, 0xc1, 0x22, 0x22, 0x22,
0xcc, 0x72, 0x37, 0x33, 0xdc, 0x32, 0x22, 0x32, 0xcc, 0x32, 0x33, 0x29, 0xdc, 0x32, 0x22, 0x62,
0xdb, 0xad, 0x49, 0x29, 0xdd, 0xbd, 0x76, 0x24, 0x37, 0x33, 0x96, 0x27, 0x32, 0x33, 0x93, 0x27,
0x32, 0x63, 0x96, 0x27, 0x62, 0x26, 0x22, 0x27, 0x22, 0x22, 0x22, 0x27, 0xa2, 0xbb, 0x9b, 0x27,
0x49, 0xc1, 0xdd, 0xdd, 0x14, 0xd1, 0xdd, 0xdd, 0x11, 0x7c, 0x77, 0x37, 0xc1, 0x77, 0x77, 0x33,
0xcc, 0x77, 0x33, 0x32, 0xdc, 0x77, 0x23, 0x32, 0xcc, 0x37, 0x22, 0x22, 0xdc, 0x23, 0x22, 0x22,
0xdd, 0x6d, 0x49, 0x29, 0xdd, 0xbd, 0x76, 0x24, 0x37, 0x33, 0x96, 0x27, 0x33, 0x33, 0x93, 0x24,
0x33, 0x63, 0x96, 0x24, 0x69, 0x66, 0x9a, 0x24, 0x22, 0xb2, 0x9b, 0x24, 0x22, 0xb2, 0x9b, 0x24,
0x49, 0xc1, 0xdd, 0xdd, 0x14, 0xd1, 0xdd, 0xdd, 0x11, 0x3c, 0x77, 0x37, 0xc1, 0x77, 0x77, 0x33,
0xcc, 0x77, 0x33, 0x22, 0xdc, 0x77, 0x33, 0x22, 0xcc, 0x37, 0x93, 0x22, 0xdc, 0x33, 0x93, 0x22,
0xdd, 0x6d, 0x49, 0x29, 0xdd, 0xbd, 0x76, 0x24, 0x37, 0x33, 0x96, 0x27, 0x33, 0x33, 0x93, 0x24,
0x32, 0x63, 0x96, 0x24, 0x62, 0x66, 0x9a, 0x24, 0x62, 0xba, 0x9b, 0x24, 0xa2, 0xbb, 0x9b, 0x24,
0x49, 0xc1, 0xdd, 0xdd, 0x14, 0xd1, 0xdd, 0xdd, 0x11, 0x7c, 0x77, 0x37, 0xc1, 0x77, 0x77, 0x33,
0xcc, 0x77, 0x33, 0x33, 0xdc, 0x77, 0x33, 0x33, 0xcc, 0x37, 0x22, 0x22, 0xdc, 0x33, 0x22, 0x22,
0xdd, 0x6d, 0x49, 0x29, 0xdd, 0xbd, 0x76, 0x24, 0x37, 0x33, 0x96, 0x27, 0x33, 0x33, 0x93, 0x24,
0x32, 0x63, 0x96, 0x24, 0x22, 0x66, 0x9a, 0x24, 0x22, 0xb2, 0x9b, 0x24, 0x22, 0x22, 0x9b, 0x24,
0x92, 0x69, 0x66, 0x26, 0x92, 0x69, 0x66, 0x26, 0x92, 0x99, 0x66, 0x26, 0x92, 0x69, 0x66, 0x26,
0x92, 0x69, 0x66, 0x26, 0x92, 0x99, 0x66, 0x26, 0x92, 0x69, 0x66, 0x26, 0x72, 0x99, 0x66, 0x26,
0xc2, 0x93, 0x29, 0x66, 0x2c, 0x92, 0x29, 0x66, 0xdc, 0x93, 0x66, 0xa6, 0xcd, 0x33, 0x66, 0xa6,
0x66, 0x36, 0x63, 0xa6, 0x94, 0x69, 0x99, 0x99, 0x49, 0x77, 0x77, 0x77, 0x22, 0x22, 0x22, 0x22,
0xb2, 0xd2, 0x92, 0x27, 0xb2, 0xd2, 0x22, 0x22, 0xdb, 0xdd, 0x9d, 0x27, 0xbb, 0xdd, 0x9b, 0x27,
0xba, 0xba, 0x79, 0x24, 0x99, 0x99, 0x47, 0x24, 0x77, 0x77, 0x44, 0x29, 0x22, 0x22, 0x22, 0x22,
0xcc, 0x93, 0x92, 0x62, 0xdc, 0x93, 0x22, 0xa6, 0xcc, 0x93, 0x66, 0xa6, 0xdc, 0x37, 0x66, 0xa6,
0x66, 0x36, 0x63, 0xa6, 0x94, 0x69, 0x99, 0x99, 0x49, 0x77, 0x77, 0x77, 0x22, 0x22, 0x22, 0x22,
0xb6, 0xd2, 0x9d, 0x27, 0x22, 0xdd, 0x9d, 0x27, 0xdb, 0xdd, 0x9d, 0x27, 0xbb, 0xdd, 0x9b, 0x27,
0xaa, 0xab, 0x79, 0x24, 0x99, 0x99, 0x47, 0x24, 0x77, 0x77, 0x44, 0x29, 0x22, 0x22, 0x22, 0x22,
0xcc, 0x92, 0x92, 0x62, 0xdc, 0x92, 0x62, 0x22, 0xcc, 0x93, 0x66, 0xa6, 0xdc, 0x37, 0x66, 0xa6,
0x66, 0x36, 0x63, 0xa6, 0x94, 0x69, 0x99, 0x99, 0x49, 0x77, 0x77, 0x77, 0x22, 0x22, 0x22, 0x22,
0xb6, 0x2d, 0x9d, 0x27, 0xb2, 0x2d, 0x9d, 0x27, 0xdb, 0xdd, 0x9d, 0x27, 0xbb, 0xdd, 0x9b, 0x27,
0xba, 0xba, 0x79, 0x24, 0x99, 0x99, 0x47, 0x24, 0x77, 0x77, 0x44, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xbb, 0xdd, 0xc1, 0xba, 0xdb, 0xcd, 0xc1, 0xba, 0xdd, 0xdd, 0xcc, 0xb6, 0xdd, 0xdc,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x96, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xcd, 0xdc, 0xac, 0x29, 0xcd, 0xcc, 0xad, 0x29, 0xcd, 0xcd, 0xac, 0x29, 0xdc, 0xcc, 0xad, 0x29,
0xcd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x79, 0x47, 0x29, 0x22, 0x22, 0x22, 0x22,
0xdc, 0x37, 0x69, 0x69, 0xcc, 0x37, 0x33, 0x66, 0xdc, 0x37, 0x33, 0x63, 0xcd, 0x33, 0x33, 0x63,
0x66, 0x36, 0x33, 0x63, 0x94, 0x69, 0x99, 0x99, 0x49, 0x77, 0x77, 0x77, 0x22, 0x22, 0x22, 0x22,
0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xaa, 0x63, 0x69, 0x69, 0x96,
0x63, 0x33, 0x36, 0x63, 0x99, 0x99, 0x99, 0x99, 0x77, 0x77, 0x77, 0x77, 0x22, 0x22, 0x22, 0x22,
0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xaa, 0xaa, 0xaa, 0xaa, 0x66, 0x66, 0x66, 0x66,
0x33, 0x99, 0x63, 0x63, 0x99, 0x99, 0x99, 0x99, 0x77, 0x77, 0x77, 0x77, 0x22, 0x22, 0x22, 0x22,
0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x22, 0xaa, 0xaa, 0xaa, 0xaa, 0x66, 0x66, 0xaa, 0xaa,
0x69, 0x69, 0x93, 0x63, 0x99, 0x99, 0x99, 0x99, 0x77, 0x77, 0x77, 0x77, 0x22, 0x22, 0x22, 0x22,
0x62, 0x62, 0x66, 0x62, 0xa6, 0x62, 0x6a, 0xa2, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
0x93, 0x36, 0x36, 0x96, 0x99, 0x99, 0x99, 0x99, 0x77, 0x77, 0x77, 0x77, 0x22, 0x22, 0x22, 0x22,
0x62, 0x62, 0x66, 0x62, 0x62, 0x2a, 0x62, 0x22, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
0x63, 0x63, 0x93, 0x63, 0x99, 0x99, 0x99, 0x99, 0x77, 0x77, 0x77, 0x77, 0x22, 0x22, 0x22, 0x22,
0x66, 0x66, 0x66, 0x66, 0x62, 0x6a, 0x66, 0x66, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x6a, 0x66, 0x66,
0x93, 0x63, 0x69, 0x69, 0x99, 0x99, 0x99, 0x99, 0x77, 0x77, 0x77, 0x77, 0x22, 0x22, 0x22, 0x22,
0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xaa, 0xaa, 0xaa, 0xaa, 0x66, 0x66, 0x66, 0x96,
0x99, 0x63, 0x93, 0x63, 0x99, 0x99, 0x99, 0x99, 0x77, 0x77, 0x77, 0x77, 0x22, 0x22, 0x22, 0x22,
0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xaa, 0x66, 0x66, 0x66, 0x96, 0x96, 0x96, 0x96,
0x63, 0x63, 0x63, 0x63, 0x99, 0x99, 0x99, 0x99, 0x77, 0x77, 0x77, 0x77, 0x22, 0x22, 0x22, 0x22,
0xb6, 0xdb, 0x9b, 0x27, 0xba, 0xbb, 0x9b, 0x27, 0xa6, 0xdb, 0x9b, 0x27, 0xa6, 0xbb, 0x9b, 0x27,
0x66, 0xba, 0x79, 0x24, 0x99, 0x99, 0x47, 0x24, 0x77, 0x77, 0x44, 0x29, 0x22, 0x22, 0x22, 0x22,
0xcc, 0x23, 0x99, 0x62, 0xdc, 0x22, 0x62, 0xa2, 0xcc, 0x93, 0x66, 0xa6, 0xdc, 0x37, 0x66, 0xa6,
0x66, 0x36, 0x63, 0xa6, 0x94, 0x69, 0x99, 0x99, 0x49, 0x99, 0x77, 0x77, 0x22, 0x22, 0x22, 0x22,
0xb2, 0xdd, 0x92, 0x24, 0xb2, 0x22, 0x9d, 0x24, 0xdb, 0xdd, 0x9d, 0x24, 0xbb, 0xdd, 0x9b, 0x24,
0xaa, 0xab, 0x79, 0x24, 0x99, 0x99, 0x47, 0x24, 0x77, 0x77, 0x44, 0x29, 0x22, 0x22, 0x22, 0x22,
0xcc, 0x23, 0x29, 0x26, 0xdc, 0x29, 0x62, 0x26, 0xcc, 0x93, 0x69, 0xa6, 0xdc, 0x37, 0x66, 0xa6,
0x66, 0x36, 0x63, 0xa6, 0x94, 0x69, 0x99, 0x99, 0x49, 0x99, 0x77, 0x77, 0x22, 0x22, 0x22, 0x22,
0xba, 0xd2, 0x9d, 0x24, 0xb2, 0x22, 0x9d, 0x24, 0xdb, 0xdd, 0x9d, 0x24, 0xbb, 0xdd, 0x9b, 0x24,
0xba, 0xba, 0x79, 0x24, 0x99, 0x99, 0x47, 0x24, 0x77, 0x77, 0x44, 0x29, 0x22, 0x22, 0x22, 0x22,
0xcc, 0x92, 0x99, 0x66, 0xdc, 0x92, 0x22, 0xa2, 0xcc, 0x92, 0x66, 0xa6, 0xdc, 0x22, 0x22, 0x22,
0x66, 0x36, 0x63, 0xa6, 0x94, 0x69, 0x99, 0x99, 0x49, 0x77, 0x77, 0x77, 0x22, 0x22, 0x22, 0x22,
0xb2, 0xdd, 0x9d, 0x27, 0xb2, 0xdd, 0x9d, 0x27, 0xd2, 0xdd, 0x9d, 0x27, 0xb2, 0xdd, 0x9b, 0x27,
0xba, 0xab, 0x79, 0x24, 0x99, 0x99, 0x47, 0x24, 0x77, 0x77, 0x44, 0x29, 0x22, 0x22, 0x22, 0x22,
0xcc, 0x93, 0x22, 0x22, 0xdc, 0x93, 0x29, 0xa2, 0xcc, 0x93, 0x66, 0xa2, 0xdc, 0x37, 0x66, 0xa6,
0x66, 0x36, 0x63, 0xa6, 0x94, 0x69, 0x99, 0x99, 0x49, 0x99, 0x77, 0x77, 0x22, 0x22, 0x22, 0x22,
0x22, 0xd2, 0x9d, 0x24, 0xbb, 0xdd, 0x9d, 0x24, 0xdb, 0xdd, 0x9d, 0x24, 0xbb, 0xdd, 0x9b, 0x24,
0xaa, 0xab, 0x79, 0x24, 0x99, 0x99, 0x47, 0x24, 0x77, 0x77, 0x44, 0x29, 0x22, 0x22, 0x22, 0x22,
0xcc, 0x93, 0x22, 0x22, 0xdc, 0x93, 0x29, 0x22, 0xcc, 0x93, 0x66, 0x22, 0xdc, 0x37, 0x66, 0x26,
0x66, 0x36, 0x63, 0xa6, 0x94, 0x69, 0x99, 0x99, 0x49, 0x77, 0x77, 0x77, 0x22, 0x22, 0x22, 0x22,
0x22, 0xd2, 0x9d, 0x24, 0x22, 0xdd, 0x9d, 0x24, 0xd2, 0xdd, 0x9d, 0x24, 0xbb, 0xdd, 0x9b, 0x24,
0xba, 0xab, 0x79, 0x24, 0x99, 0x99, 0x47, 0x24, 0x77, 0x77, 0x44, 0x29, 0x22, 0x22, 0x22, 0x22,
0xcc, 0x93, 0x22, 0x22, 0xdc, 0x93, 0x69, 0xa6, 0xcc, 0x93, 0x66, 0xa6, 0xdc, 0x37, 0x66, 0xa6,
0x66, 0x36, 0x63, 0xa6, 0x94, 0x69, 0x99, 0x99, 0x49, 0x99, 0x77, 0x77, 0x22, 0x22, 0x22, 0x22,
0x22, 0xd2, 0x9d, 0x24, 0x22, 0xdd, 0x9d, 0x24, 0xd2, 0xdd, 0x9d, 0x24, 0xbb, 0xdd, 0x9b, 0x24,
0xaa, 0xab, 0x79, 0x24, 0x99, 0x99, 0x47, 0x24, 0x77, 0x77, 0x44, 0x29, 0x22, 0x22, 0x22, 0x22,
0x66, 0x66, 0x96, 0x29, 0x66, 0x66, 0x96, 0x29, 0x66, 0x66, 0x96, 0x29, 0x66, 0x66, 0x99, 0x29,
0x66, 0x66, 0x96, 0x29, 0x66, 0x66, 0x99, 0x29, 0x66, 0x66, 0x96, 0x29, 0x66, 0x66, 0x96, 0x27,
0x72, 0x97, 0x66, 0x66, 0x72, 0x77, 0x69, 0x66, 0x22, 0x74, 0x97, 0x66, 0x20, 0x44, 0x74, 0x97,
0x20, 0x42, 0x44, 0x44, 0x00, 0x22, 0x44, 0x44, 0x00, 0x20, 0x22, 0x44, 0x00, 0x00, 0x20, 0x22,
0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x99, 0x99, 0x99, 0x99,
0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x22, 0x22, 0x22, 0x22,
0x66, 0x96, 0x79, 0x27, 0x66, 0x96, 0x77, 0x27, 0x66, 0x79, 0x47, 0x22, 0x79, 0x47, 0x44, 0x02,
0x44, 0x44, 0x24, 0x02, 0x44, 0x44, 0x22, 0x00, 0x44, 0x22, 0x02, 0x00, 0x22, 0x02, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x49, 0xc1, 0xcc, 0xcc, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0x2a,
0xc1, 0x69, 0xa6, 0x2a, 0xc1, 0xa9, 0xaa, 0x2b, 0xc1, 0x66, 0xba, 0x2d, 0xc1, 0xaa, 0xbb, 0x2d,
0x49, 0xc1, 0xdd, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0x22,
0xc1, 0x69, 0x26, 0xba, 0xc1, 0xa9, 0xa2, 0x2b, 0xc1, 0xa9, 0xb2, 0xd2, 0xc1, 0xaa, 0xb2, 0xd2,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0xb2, 0xdb, 0xad, 0x29,
0x2b, 0xdd, 0xad, 0x29, 0xd2, 0xd2, 0xad, 0x29, 0xd2, 0xd2, 0xac, 0x29, 0xd2, 0xc2, 0xad, 0x29,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0x2a,
0xc1, 0x69, 0xa6, 0x2a, 0xc1, 0xa9, 0x2a, 0x22, 0xc1, 0x66, 0xba, 0xd2, 0xc1, 0xaa, 0xbb, 0xd2,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0x2a, 0xdb, 0xad, 0x29,
0x2b, 0xdd, 0xad, 0x29, 0x22, 0xd2, 0xad, 0x29, 0xd2, 0xdc, 0xac, 0x29, 0xd2, 0xcd, 0xad, 0x29,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0x2a,
0xc1, 0x69, 0xa6, 0x22, 0xc1, 0xa9, 0x2a, 0x2b, 0xc1, 0x66, 0x2a, 0x2d, 0xc1, 0xaa, 0xbb, 0x22,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0xba, 0xdb, 0xad, 0x29,
0xb2, 0xdd, 0xad, 0x29, 0x2d, 0xdd, 0xad, 0x29, 0xdd, 0xdc, 0xac, 0x29, 0xd2, 0xcd, 0xad, 0x29,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x26, 0xaa,
0xc1, 0x69, 0xa2, 0xa2, 0xc1, 0xa9, 0xa2, 0xb2, 0xc1, 0xa6, 0x2a, 0xdd, 0xc1, 0xa6, 0xbb, 0x2d,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0x2a, 0xdb, 0xad, 0x29,
0x2b, 0xdd, 0xad, 0x29, 0xd2, 0xdd, 0xad, 0x29, 0xd2, 0xdc, 0xac, 0x29, 0xdd, 0xcd, 0xad, 0x29,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0x2a,
0xc1, 0x69, 0xa6, 0xb2, 0xc1, 0xa9, 0xaa, 0xbb, 0xc1, 0x66, 0xba, 0xdd, 0xc1, 0xaa, 0xbb, 0xdd,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0xba, 0xdb, 0xad, 0x29,
0xb2, 0xdd, 0xad, 0x29, 0xdd, 0xdd, 0xad, 0x29, 0xdd, 0xdc, 0xac, 0x29, 0xdd, 0xcd, 0xad, 0x29,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0x2a,
0xc1, 0x69, 0xa6, 0xb2, 0xc1, 0xa9, 0xaa, 0xb2, 0xc1, 0x66, 0xba, 0xd2, 0xc1, 0xaa, 0xbb, 0x2d,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0xba, 0xdb, 0xad, 0x29,
0xb2, 0xdd, 0xad, 0x29, 0xd2, 0xdd, 0xad, 0x29, 0xd2, 0xdc, 0xac, 0x29, 0xdd, 0xcd, 0xad, 0x29,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0x2a,
0xc1, 0x69, 0xa2, 0x2a, 0xc1, 0xa9, 0x2a, 0x2b, 0xc1, 0x66, 0xba, 0x22, 0xc1, 0xaa, 0x2b, 0x2d,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0xba, 0xdb, 0xad, 0x29,
0xbb, 0xd2, 0xad, 0x29, 0x2d, 0xdd, 0xad, 0x29, 0xd2, 0xdc, 0xac, 0x29, 0x2d, 0xcd, 0xad, 0x29,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0xaa,
0xc1, 0x69, 0xa6, 0x2a, 0xc1, 0xa9, 0xaa, 0x2b, 0xc1, 0x66, 0xba, 0xd2, 0xc1, 0xaa, 0xbb, 0xd2,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0xa2,
0xc1, 0x69, 0xa6, 0x2a, 0xc1, 0xa9, 0xaa, 0x2b, 0xc1, 0x66, 0xba, 0xdd, 0xc1, 0xaa, 0xbb, 0xdd,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0xba, 0xdb, 0xad, 0x29,
0xbb, 0xdd, 0xad, 0x29, 0xdd, 0xdd, 0xad, 0x29, 0xd2, 0xdc, 0xac, 0x29, 0xd2, 0xcd, 0xad, 0x29,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0xaa,
0xc1, 0x69, 0xa6, 0xaa, 0xc1, 0xa9, 0xaa, 0x2b, 0xc1, 0x66, 0xba, 0x2d, 0xc1, 0xaa, 0x2a, 0x22,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x29, 0xba, 0xdb, 0xad, 0x27,
0xbb, 0xdd, 0xad, 0x27, 0xdd, 0xdd, 0xad, 0x27, 0xdd, 0xdc, 0xac, 0x27, 0x22, 0xcd, 0xad, 0x27,
0xc1, 0xaa, 0xbb, 0x2d, 0xc1, 0xba, 0xdb, 0xdd, 0xc1, 0xba, 0xdd, 0x2d, 0xcc, 0xb6, 0xdd, 0x2d,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6a, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xd2, 0xd2, 0xc1, 0xba, 0xd2, 0x2d, 0xc1, 0xb6, 0x2d, 0xdd, 0xcc, 0xba, 0xdd, 0x22,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xc2, 0xc2, 0xac, 0x29, 0x22, 0xdc, 0xac, 0x29, 0xdc, 0xcc, 0xac, 0x29, 0x22, 0xdc, 0xad, 0x29,
0xcd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xbb, 0xd2, 0xc1, 0xba, 0x22, 0x22, 0xc1, 0xb6, 0x2d, 0x2d, 0xcc, 0xba, 0x2d, 0x2d,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xc2, 0xdc, 0xac, 0x29, 0x22, 0xcc, 0xad, 0x29, 0xcd, 0xcd, 0xac, 0x29, 0xdc, 0xcc, 0xad, 0x29,
0xcd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xbb, 0x2d, 0xc1, 0xba, 0x2b, 0x2d, 0xc1, 0xba, 0xdd, 0x22, 0xcc, 0xb6, 0xdd, 0x2d,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0x2d, 0xcc, 0xac, 0x29, 0x2d, 0xdc, 0xac, 0x29, 0xd2, 0xcc, 0xac, 0x29, 0xcd, 0xdc, 0xad, 0x29,
0xdc, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xbb, 0xd2, 0xc1, 0xba, 0xdb, 0xd2, 0xc1, 0xba, 0x2d, 0xdd, 0xcc, 0xb6, 0x2d, 0xdc,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0x2d, 0xdc, 0xac, 0x29, 0xc2, 0xc2, 0xac, 0x29, 0xd2, 0xc2, 0xad, 0x29, 0x2c, 0xdc, 0xac, 0x29,
0xdd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xbb, 0xd2, 0xc1, 0xba, 0x2b, 0xdd, 0xc1, 0xb6, 0x2d, 0xdd, 0xcc, 0xba, 0xdd, 0x22,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xc2, 0xc2, 0xac, 0x29, 0x2d, 0xdc, 0xac, 0x29, 0x2c, 0xcc, 0xac, 0x29, 0xd2, 0xd2, 0xad, 0x29,
0xcd, 0xcd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xd2, 0x2d, 0xc1, 0xba, 0xdb, 0x2d, 0xc1, 0xba, 0xdd, 0xdd, 0xcc, 0xb6, 0xdd, 0xcd,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xcd, 0xc2, 0xac, 0x29, 0xcd, 0xcd, 0xad, 0x29, 0xdc, 0xcc, 0xac, 0x29, 0xcd, 0xdc, 0xad, 0x29,
0xdd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xbb, 0xd2, 0xc1, 0xba, 0xdb, 0x2d, 0xc1, 0xba, 0xdd, 0x2d, 0xcc, 0xb6, 0xdd, 0xdd,
0xdd, 0xbd, 0xdb, 0xcd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xcd, 0xdc, 0xac, 0x29, 0xcd, 0xcc, 0xad, 0x29, 0xcd, 0xcd, 0xac, 0x29, 0xd2, 0xcc, 0xad, 0x29,
0xcd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xbb, 0xdd, 0xc1, 0xba, 0xdb, 0x2d, 0xc1, 0xba, 0xdd, 0x2d, 0xcc, 0xb6, 0xdd, 0xc2,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xbb, 0xdd, 0xc1, 0xba, 0xdb, 0xcd, 0xc1, 0xba, 0xdd, 0xdd, 0xcc, 0xb6, 0x2d, 0x22,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xbb, 0x2d, 0xc1, 0xba, 0xdb, 0x2d, 0xc1, 0xba, 0xdd, 0xdd, 0xcc, 0xb6, 0xdd, 0xcd,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xcd, 0xdc, 0xac, 0x27, 0xcd, 0xcd, 0xac, 0x27, 0xdc, 0xcc, 0xad, 0x27, 0xcd, 0xdc, 0xac, 0x27,
0xdd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0x22,
0xc1, 0x69, 0x26, 0xba, 0xc1, 0xa9, 0x2a, 0xbb, 0xc1, 0x66, 0x2a, 0xdd, 0xc1, 0xaa, 0x2b, 0xdd,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0xb2, 0xdb, 0xad, 0x29,
0x2b, 0xdd, 0xad, 0x29, 0x2d, 0xdd, 0xad, 0x29, 0x2d, 0xdc, 0xac, 0x29, 0x2d, 0xcd, 0xad, 0x29,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x26, 0xaa,
0xc1, 0x69, 0x26, 0xaa, 0xc1, 0xa9, 0x2a, 0x2b, 0xc1, 0x66, 0x2a, 0x2d, 0xc1, 0xaa, 0x2b, 0x2d,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x26, 0x22,
0xc1, 0x69, 0xa6, 0x2a, 0xc1, 0xa9, 0xaa, 0x2b, 0xc1, 0x66, 0xba, 0x2d, 0xc1, 0xaa, 0xbb, 0x2d,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0x22, 0xdb, 0xad, 0x29,
0xbb, 0xdd, 0xad, 0x29, 0xdd, 0xdd, 0xad, 0x29, 0xdd, 0xdc, 0xac, 0x29, 0xdd, 0xcd, 0xad, 0x29,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x26, 0xaa,
0xc1, 0x69, 0x26, 0xaa, 0xc1, 0xa9, 0xaa, 0xb2, 0xc1, 0x66, 0xba, 0xd2, 0xc1, 0xaa, 0xbb, 0x2d,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0x2a,
0xc1, 0x69, 0xa6, 0x2a, 0xc1, 0xa9, 0xaa, 0x2b, 0xc1, 0x66, 0xba, 0x2d, 0xc1, 0xaa, 0xbb, 0x2d,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0x2a,
0xc1, 0x69, 0xa6, 0xb2, 0xc1, 0xa9, 0xaa, 0xb2, 0xc1, 0x66, 0xba, 0xd2, 0xc1, 0xaa, 0x2a, 0xdd,
0xdd, 0xdd, 0x4b, 0x29, 0xcc, 0xcc, 0x6b, 0x24, 0xa6, 0xba, 0xad, 0x26, 0xba, 0xbb, 0xad, 0x29,
0xb2, 0xdd, 0xad, 0x29, 0xd2, 0xdd, 0xad, 0x29, 0xd2, 0xdc, 0xac, 0x29, 0x2d, 0xcd, 0xad, 0x29,
0x49, 0xc1, 0xcc, 0xcc, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0x2a,
0xc1, 0x69, 0xa6, 0x2a, 0xc1, 0xa9, 0xaa, 0x2b, 0xc1, 0x66, 0xba, 0x2d, 0xc1, 0xaa, 0xbb, 0xdd,
0xc1, 0xaa, 0x2b, 0xdd, 0xc1, 0xba, 0x2b, 0xdd, 0xc1, 0xb6, 0x2d, 0x2d, 0xcc, 0xba, 0xdd, 0x22,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0x2d, 0xdc, 0xac, 0x29, 0x2c, 0xcc, 0xad, 0x29, 0x2d, 0xcd, 0xac, 0x29, 0xc2, 0xcc, 0xad, 0x29,
0x22, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0x2b, 0x2d, 0xc1, 0xba, 0xdb, 0xd2, 0xc1, 0xba, 0xdd, 0xd2, 0xcc, 0xb6, 0xdd, 0xd2,
0xdd, 0xbd, 0xdb, 0xcd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0x2d, 0xdc, 0xac, 0x29, 0xc2, 0xcc, 0xad, 0x29, 0xc2, 0xcd, 0xac, 0x29, 0xd2, 0xcc, 0xad, 0x29,
0xcd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0x2b, 0xdd, 0xc1, 0xba, 0x2b, 0xdd, 0xc1, 0xb6, 0x2d, 0xdd, 0xcc, 0xba, 0x2d, 0xcd,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xc2, 0xdc, 0xac, 0x29, 0xd2, 0xcc, 0xad, 0x29, 0x2c, 0xcd, 0xac, 0x29, 0x2d, 0xcc, 0xad, 0x29,
0xdc, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0x2b, 0xdd, 0xc1, 0xba, 0x2b, 0xdd, 0xc1, 0xb6, 0x2d, 0xdc, 0xcc, 0xba, 0x2d, 0xdd,
0xdd, 0xbd, 0xdb, 0xcd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xd2, 0xcc, 0xac, 0x29, 0xc2, 0xcd, 0xad, 0x29, 0xd2, 0xcc, 0xac, 0x29, 0xcd, 0xdc, 0xad, 0x29,
0xdc, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xbb, 0x2d, 0xc1, 0xba, 0xdb, 0x2d, 0xc1, 0xba, 0xdd, 0x2d, 0xcc, 0xb6, 0xdd, 0x2d,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x66, 0x66, 0x22, 0x22, 0x22, 0x22,
0xcd, 0xdc, 0xac, 0x27, 0xcd, 0xcc, 0xad, 0x27, 0xcd, 0xcd, 0xac, 0x27, 0xdc, 0xcc, 0xad, 0x27,
0xcd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x66, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0x2a,
0xc1, 0x69, 0xa6, 0x2a, 0xc1, 0xa9, 0xaa, 0xb2, 0xc1, 0x66, 0xba, 0xd2, 0xc1, 0xaa, 0xbb, 0xd2,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0xba, 0xdb, 0xad, 0x29,
0xbb, 0xdd, 0xad, 0x29, 0xd2, 0xdd, 0xad, 0x29, 0xd2, 0xdc, 0xac, 0x29, 0xd2, 0xcd, 0xad, 0x29,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x26, 0x22,
0xc1, 0x69, 0x26, 0xba, 0xc1, 0xa9, 0x2a, 0xbb, 0xc1, 0x66, 0x2a, 0xdd, 0xc1, 0xaa, 0x2b, 0xdd,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0x22,
0xc1, 0x69, 0xa6, 0xb2, 0xc1, 0xa9, 0xaa, 0xb2, 0xc1, 0x66, 0xba, 0xd2, 0xc1, 0xaa, 0xbb, 0x22,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0x22, 0xdb, 0xad, 0x29,
0xbb, 0xdd, 0xad, 0x29, 0xdd, 0xdd, 0xad, 0x29, 0xdd, 0xdc, 0xac, 0x29, 0x22, 0xcd, 0xad, 0x29,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x26, 0xaa,
0xc1, 0x69, 0x26, 0xaa, 0xc1, 0xa9, 0x2a, 0xbb, 0xc1, 0x66, 0x2a, 0xdd, 0xc1, 0xaa, 0x2b, 0x22,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0x2a, 0xdb, 0xad, 0x29,
0x2b, 0xdd, 0xad, 0x29, 0x2d, 0xdd, 0xad, 0x29, 0x2d, 0xdc, 0xac, 0x29, 0x22, 0xcd, 0xad, 0x29,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0xb2, 0xdb, 0xad, 0x29,
0xb2, 0xdd, 0xad, 0x29, 0xd2, 0xdd, 0xad, 0x29, 0xd2, 0xdc, 0xac, 0x29, 0xd2, 0xcd, 0xad, 0x29,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x26, 0xaa,
0xc1, 0x69, 0x26, 0xaa, 0xc1, 0xa9, 0x2a, 0xbb, 0xc1, 0x66, 0x2a, 0x2d, 0xc1, 0xaa, 0x2b, 0xd2,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0x2a, 0xdb, 0xad, 0x29,
0xb2, 0xdd, 0xad, 0x29, 0xd2, 0xdd, 0xad, 0x29, 0xdd, 0xdc, 0xac, 0x29, 0xdd, 0xcd, 0xad, 0x29,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0xa2,
0xc1, 0x69, 0xa6, 0xb2, 0xc1, 0xa9, 0xaa, 0xb2, 0xc1, 0x66, 0xba, 0xdd, 0xc1, 0xaa, 0xbb, 0xdd,
0xc1, 0xaa, 0x2b, 0x22, 0xc1, 0xba, 0x2b, 0xdd, 0xc1, 0xb6, 0x2d, 0xdd, 0xcc, 0xba, 0x2d, 0xcd,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xbb, 0xdd, 0xc1, 0xba, 0xdb, 0xdd, 0xc1, 0xba, 0xdd, 0xdc, 0xcc, 0xb6, 0x2d, 0x22,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xc2, 0xdc, 0xac, 0x29, 0xd2, 0xcc, 0xad, 0x29, 0xc2, 0xcd, 0xac, 0x29, 0xdc, 0xcc, 0xad, 0x29,
0xcd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0x2b, 0xdd, 0xc1, 0xba, 0x2b, 0xdd, 0xc1, 0xb6, 0x2d, 0xcd, 0xcc, 0xba, 0x2d, 0x22,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0x2b, 0xdd, 0xc1, 0xba, 0x2b, 0xdd, 0xc1, 0xb6, 0x2d, 0xcd, 0xcc, 0xba, 0x2d, 0xdd,
0xdd, 0xbd, 0xdb, 0xcd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0x2d, 0xdc, 0xac, 0x29, 0x2c, 0xcc, 0xad, 0x29, 0x2d, 0xcd, 0xac, 0x29, 0x2d, 0xcc, 0xad, 0x29,
0xcd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0x2b, 0x2d, 0xc1, 0xba, 0x2b, 0xdd, 0xc1, 0xb6, 0x2d, 0xdd, 0xcc, 0xba, 0x2d, 0xdc,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xcd, 0xdc, 0xac, 0x29, 0xd2, 0xcc, 0xad, 0x29, 0xc2, 0xcd, 0xac, 0x29, 0x2c, 0xcc, 0xad, 0x29,
0xdd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xbb, 0xdd, 0xc1, 0xba, 0xdb, 0xcd, 0xc1, 0xba, 0xdd, 0x2d, 0xcc, 0xb6, 0xdd, 0xdd,
0xdd, 0xbd, 0xdb, 0xcd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x26, 0x22,
0xc1, 0x69, 0xa6, 0xba, 0xc1, 0xa9, 0xaa, 0x2b, 0xc1, 0x66, 0xba, 0x2d, 0xc1, 0xaa, 0xbb, 0x22,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0xb2, 0xdb, 0xad, 0x29,
0xb2, 0xdd, 0xad, 0x29, 0xdd, 0xdd, 0xad, 0x29, 0xdd, 0xdc, 0xac, 0x29, 0xdd, 0xcd, 0xad, 0x29,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x26, 0xaa,
0xc1, 0x69, 0x26, 0xaa, 0xc1, 0xa9, 0x2a, 0xbb, 0xc1, 0x66, 0xba, 0xd2, 0xc1, 0xaa, 0xbb, 0xd2,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0x2a, 0xdb, 0xad, 0x29,
0x2b, 0xdd, 0xad, 0x29, 0x2d, 0xdd, 0xad, 0x29, 0xd2, 0xdc, 0xac, 0x29, 0xd2, 0xcd, 0xad, 0x29,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x26, 0xaa,
0xc1, 0x69, 0x26, 0xa2, 0xc1, 0xa9, 0x2a, 0xb2, 0xc1, 0x66, 0x2a, 0x2d, 0xc1, 0xaa, 0x2b, 0x2d,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x26, 0xaa,
0xc1, 0x69, 0x26, 0xaa, 0xc1, 0xa9, 0x2a, 0xb2, 0xc1, 0x66, 0x2a, 0xd2, 0xc1, 0xaa, 0x2b, 0x2d,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0x2a, 0xdb, 0xad, 0x29,
0x2b, 0xdd, 0xad, 0x29, 0x22, 0xdd, 0xad, 0x29, 0x22, 0xdc, 0xac, 0x29, 0x2d, 0xcd, 0xad, 0x29,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0xaa,
0xc1, 0x69, 0xa6, 0xaa, 0xc1, 0xa9, 0xaa, 0xbb, 0xc1, 0x66, 0xba, 0x2d, 0xc1, 0xaa, 0xbb, 0xd2,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0xaa,
0xc1, 0x69, 0xa6, 0xaa, 0xc1, 0xa9, 0xaa, 0xb2, 0xc1, 0x66, 0xba, 0x2d, 0xc1, 0xaa, 0xbb, 0xdd,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0xba, 0xdb, 0xad, 0x29,
0xbb, 0xdd, 0xad, 0x29, 0xdd, 0xdd, 0xad, 0x29, 0xdd, 0xdc, 0xac, 0x29, 0xd2, 0xcd, 0xad, 0x29,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x26, 0x22,
0xc1, 0x69, 0xa6, 0xba, 0xc1, 0xa9, 0xaa, 0xbb, 0xc1, 0x66, 0xba, 0x2d, 0xc1, 0xaa, 0xbb, 0xd2,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0xba, 0xdb, 0xad, 0x29,
0xb2, 0xdd, 0xad, 0x29, 0xd2, 0xdd, 0xad, 0x29, 0xdd, 0xdc, 0xac, 0x29, 0xdd, 0xcd, 0xad, 0x29,
0xc1, 0xaa, 0xbb, 0xd2, 0xc1, 0xba, 0xdb, 0xd2, 0xc1, 0xba, 0x2d, 0xdd, 0xcc, 0xb6, 0x2d, 0x22,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xbb, 0xd2, 0xc1, 0xba, 0xdb, 0xd2, 0xc1, 0xba, 0x2d, 0xdd, 0xcc, 0xb6, 0x2d, 0xcd,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xc2, 0xdc, 0xac, 0x29, 0xd2, 0xcc, 0xad, 0x29, 0xcd, 0xcd, 0xac, 0x29, 0xdc, 0xcc, 0xad, 0x29,
0xcd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x66, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0x2b, 0xdd, 0xc1, 0xba, 0x2b, 0xdd, 0xc1, 0xb6, 0x2d, 0xcd, 0xcc, 0xba, 0x2d, 0x22,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x66, 0x66, 0x22, 0x22, 0x22, 0x22,
0x2d, 0xdc, 0xac, 0x29, 0x2c, 0xcc, 0xad, 0x29, 0x2d, 0xcd, 0xac, 0x29, 0xc2, 0xcc, 0xad, 0x29,
0xdd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x66, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0x2b, 0xdd, 0xc1, 0xba, 0x2b, 0xdd, 0xc1, 0xb6, 0x2d, 0xcd, 0xcc, 0xba, 0x2d, 0xdd,
0xdd, 0xbd, 0xdb, 0xcd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x66, 0x66, 0x22, 0x22, 0x22, 0x22,
0x22, 0xdc, 0xac, 0x29, 0x22, 0xcc, 0xad, 0x29, 0x2d, 0xcd, 0xac, 0x29, 0x2c, 0xcc, 0xad, 0x29,
0xdd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x66, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0x2b, 0x2d, 0xc1, 0xba, 0x2b, 0xdd, 0xc1, 0xb6, 0x2d, 0xdd, 0xcc, 0xba, 0x2d, 0xdc,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x66, 0x66, 0x22, 0x22, 0x22, 0x22,
0x2d, 0xdc, 0xac, 0x29, 0x2c, 0xcc, 0xad, 0x29, 0x2d, 0xcd, 0xac, 0x29, 0x2c, 0xcc, 0xad, 0x29,
0xdd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x66, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xbb, 0x2d, 0xc1, 0xba, 0xdb, 0xdd, 0xc1, 0xba, 0xdd, 0xcd, 0xcc, 0xb6, 0xdd, 0xdd,
0xdd, 0xbd, 0xdb, 0xcd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xcd, 0xdc, 0xac, 0x29, 0xd2, 0xcc, 0xad, 0x29, 0xcd, 0xcd, 0xac, 0x29, 0xdc, 0xcc, 0xad, 0x29,
0xdd, 0xdd, 0x9b, 0x27, 0xbb, 0xab, 0x79, 0x24, 0x99, 0x66, 0x49, 0x29, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xbb, 0x2d, 0xc1, 0xba, 0xdb, 0xd2, 0xc1, 0xba, 0xdd, 0xcd, 0xcc, 0xb6, 0xdd, 0xdd,
0xdd, 0xbd, 0xdb, 0xcd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0xc1, 0xaa, 0xbb, 0xd2, 0xc1, 0xba, 0xdb, 0xcd, 0xc1, 0xba, 0xdd, 0xd2, 0xcc, 0xb6, 0xdd, 0xd2,
0xdd, 0xbd, 0xdb, 0xdd, 0xb4, 0xbb, 0xbb, 0xbb, 0x49, 0x6b, 0x99, 0x99, 0x22, 0x22, 0x22, 0x22,
0x49, 0xc1, 0xdc, 0xdd, 0x14, 0xc1, 0xcc, 0xcc, 0x11, 0xac, 0x69, 0x66, 0x11, 0x9a, 0x66, 0xaa,
0xc1, 0x69, 0xa6, 0xa2, 0xc1, 0xa9, 0x2a, 0x2b, 0xc1, 0x66, 0xba, 0xdd, 0xc1, 0xaa, 0xbb, 0xdd,
0xcc, 0xcc, 0x4b, 0x29, 0xcc, 0xdc, 0x6b, 0x24, 0xa6, 0xbb, 0xad, 0x26, 0xba, 0xdb, 0xad, 0x29,
0xbb, 0xdd, 0xad, 0x29, 0x2d, 0xdd, 0xad, 0x29, 0xd2, 0xdc, 0xac, 0x29, 0xdd, 0xcd, 0xad, 0x29
};

const unsigned short keyboard_Palette[16] = {
0x0000, 0x7fff, 0x0000, 0x6652, 0x49ad, 0x2d08, 0x72b5, 0x5a31,
0x24e7, 0x6694, 0x72f7, 0x7718, 0x7fde, 0x7b39, 0x14a5, 0x0842
};

// const unsigned short keyboard_Palette[16] = {
// 0x0000, 0x7fff, 0x7fde, 0x7b39, 0x7718, 0x72f7, 0x72b5, 0x6694,
// 0x5a31, 0x49ad, 0x6652, 0x14a5, 0x0842, 0x0000, 0x0000, 0x0000
// };

const unsigned short keyboard_Palette_Hilight[16] = {
0x0000, 0x7fff, 0x0000, 0x4d7f, 0x301f, 0x0000, 0x5e3f, 0x451f,
0x0000, 0x51bf, 0x627f, 0x66bf, 0x7fdf, 0x6f1f, 0x14a5, 0x0842
};
